#include "CommandLine.h"
#include "Tile.h"
#include <iostream>

// Seadragon download: http://gallery.expression.microsoft.com/SeadragonAjax
// file format overview: http://go.microsoft.com/fwlink/?LinkId=164944 -> http://msdn.microsoft.com/en-us/library/cc645077%28VS.95%29.aspx

void Progress(const std::string &msg) {
	std::cout << msg << std::endl;
}

int main(int argc, char *argv[]) {
	try {
		CommandLine cl(argc, argv);
		if (cl.Length() == 0) {
			// tile size, overlap, type
			std::cout << "Usage: zoom -i image.png  [-s 256 ] [ -o 1 ] [-t type]" << std::endl; 
			return 1;
		}

		std::string fileName;
		if (!cl.GetOpt("-i", fileName)) {
			std::cout << "An image name must be specified" << std::endl;
			return 1;
		}

		int tileSize=256, overlap=1;
		cl.GetOpt("-s", tileSize);
		cl.GetOpt("-o", overlap);
		std::string ext;
		if (cl.GetOpt("-t", ext)) {
			if (ext[0]!='.')
				ext = "." + ext;
		}

		Tile(fileName, ext, tileSize, overlap, Progress);
	} catch (std::exception &e) {
		std::cout << "Error: " << e.what() << std::endl;
	}
	return 0;	
}