#include "ImageBuilder.h"
#include "CommandLine.h"
#include "FileManagement.h"
#include <iostream>
#include <fstream>

// Blue Marble Next Generation data converter
// Description: http://visibleearth.nasa.gov/view_rec.php?id=7862
// Data: http://visibleearth.nasa.gov/view_detail.php?id=7862

int main(int argc, char *argv[]) {
	try {
		CommandLine cl(argc, argv);
		if (cl.Length() == 0) {
			std::cout << "Usage: bmng -d data.bin -i out.img" << std::endl; 
			return 1;
		}

		std::string dataFileName;
		if (!cl.GetOpt("-d", dataFileName)) {
			std::cout << "A data file name must be specified" << std::endl;
			return 1;
		}

		std::string imageFileName;
		if (!cl.GetOpt("-i", imageFileName)) {
			std::cout << "An image file name must be specified" << std::endl;
			return 1;
		}

		ImageWriterPtr writer = ImageBuilder::GetImageBuilder(imageFileName)->GetWriter();

		// can't be JPEG as  #define JPEG_MAX_DIMENSION  65500L  /* a tad under 64K to prevent overflows */
		writer->Open(imageFileName, 86400,43200, 3,8);  // data is 8 bits/channel RGB
		ImageRow row = writer->GetImageRow();

		unsigned int rowsWritten = 0;
		std::ifstream in(dataFileName.c_str(), std::ios::in|std::ios::binary);
		if (in.is_open()) {
			while (in.good()) {
				if (rowsWritten%1000 == 0)
					std::cout << rowsWritten << std::endl;

				in.read((char *)row.Get(), 3*writer->GetWidth());
								
				if (rowsWritten < writer->GetHeight()) {
					writer->WriteRow(row);
					rowsWritten++;
				}
			}
		}

		std::cout << "Rows written: " << rowsWritten << std::endl;
	} catch (std::exception &e) {
		std::cout << "Error: " << e.what() << std::endl;
	}

	return 0;
}