#include "ImageRow.h"


ImageRow::ImageRow(unsigned int width, unsigned int channelCount, unsigned int channelDepth) :
_width(width), _channelCount(channelCount), _channelDepth(channelDepth) {
	if ((channelCount != 1) && (channelCount != 3) && (channelCount != 4))
		throw ImageException("Invalid channel count");

	if ((channelDepth != 8) && (channelDepth != 16))
		throw ImageException("Invalid channel depth");

	_row.resize(_width * GetPixelWidth(), 0);
}



void ImageRow::Convert(ImageRow &row) const {
	unsigned short r, g, b, a;
	unsigned int width = (GetWidth()<row.GetWidth())?GetWidth():row.GetWidth();
	for (unsigned int i=0; i<width; i++) {
		GetPixel(i, r,g,b,a);
		row.SetPixel(i, r,g,b,a);
	}
}


void ImageRow::GetPixel(unsigned int x, unsigned char &r, unsigned char &g, unsigned char &b, unsigned char &a) const {
	const unsigned char *p = &_row[x * GetPixelWidth()];
	a = 255;
	if (GetChannelDepth() == 8) {
		// copy the byte
		r = *p++;
		g = *p++;
		b = *p++;
		if (GetChannelCount() == 4) a = *p++;
	} else {
		// take the high byte only (big endian)
		r = *p++; p++;
		g = *p++; p++;
		b = *p++; p++;
		if (GetChannelCount() == 4) { a = *p++; p++; }
	}
}


void ImageRow::GetPixel(unsigned int x, unsigned short &r, unsigned short &g, unsigned short &b, unsigned short &a) const {
	const unsigned char *p = &_row[x * GetPixelWidth()];
	a = 65535;
	if (GetChannelDepth() == 8) {
		// copy the byte, multiply to scale
		r = *p++ << 8;
		g = *p++ << 8;
		b = *p++ << 8;
		if (GetChannelCount() == 4) a = *p++ << 8;
	} else {
		// copy the word (big endian)
		r = (*p++ << 8); r += *p++;  // doesn't work as one statement
		g = (*p++ << 8); g += *p++;
		b = (*p++ << 8); b += *p++;
		if (GetChannelCount() == 4) { a = (*p++ << 8); a += *p++; }
	}
}



void ImageRow::SetPixel(unsigned int x, unsigned char r, unsigned char g, unsigned char b, unsigned char a) {
	unsigned char *p = &_row[x * GetPixelWidth()];
	if (GetChannelDepth() == 8) {
		// copy the byte
		*p++ = r;
		*p++ = g;
		*p++ = b;
		if (GetChannelCount() == 4) *p++ = a;
	} else {
		// take the high byte only (big endian)
		*p++ = r; p++;
		*p++ = g; p++;
		*p++ = b; p++;
		if (GetChannelCount() == 4) { *p++ = a; p++; }
	}
}

void ImageRow::SetPixel(unsigned int x, unsigned short r, unsigned short g, unsigned short b, unsigned short a) {
	unsigned char *p = &_row[x * GetPixelWidth()];
	if (GetChannelDepth() == 8) {
		// copy the byte, multiply to scale
		*p++ = (r >> 8);
		*p++ = (g >> 8);
		*p++ = (b >> 8);
		if (GetChannelCount() == 4) *p++ = (a >> 8);
	} else {
		// copy the word (big endian)
		*p++ = (r >> 8); *p++ = r % 256;
		*p++ = (g >> 8); *p++ = g % 256;
		*p++ = (b >> 8); *p++ = b % 256;
		if (GetChannelCount() == 4) { *p++ = (a >> 8); *p++ = a % 256; }
	}
}




