#ifndef __IMAGEROW_H__
#define __IMAGEROW_H__

#include "ImageLib.h"
#include <vector>

class EXT_CLASS_IMAGELIB ImageRow {
	unsigned int _width;
	unsigned int _channelCount;  // 3 or 4
	unsigned int _channelDepth;  // 8 or 16
	std::vector<unsigned char> _row;

public:
	// create
	ImageRow(unsigned int width = 0, unsigned int channelCount = 4, unsigned int channelDepth = 16);

	// properties
	unsigned int GetWidth() const { return _width; }
	unsigned int GetChannelCount() const { return _channelCount; }
	unsigned int GetChannelDepth() const { return _channelDepth; }
	unsigned int GetPixelWidth() const { return GetChannelCount() * (GetChannelDepth()>>3); }

	// buffer
	unsigned char *Get() { return &_row[0]; }
	const unsigned char *Get() const { return &_row[0]; }

	// read/write
	void Convert(ImageRow &row) const;
	void GetPixel(unsigned int x, unsigned char &r, unsigned char &g, unsigned char &b, unsigned char &a) const;
	void GetPixel(unsigned int x, unsigned short &r, unsigned short &g, unsigned short &b, unsigned short &a) const;
	void SetPixel(unsigned int x, unsigned char r, unsigned char g, unsigned char b, unsigned char a);
	void SetPixel(unsigned int x, unsigned short r, unsigned short g, unsigned short b, unsigned short a);
};


#endif
