#ifndef __IMAGEBASE_H__
#define __IMAGEBASE_H__

#include "ImageRow.h"
#include <string>
#include <stdio.h>
#include <memory>

class EXT_CLASS_IMAGELIB ImageReader;
class EXT_CLASS_IMAGELIB ImageWriter;

class EXT_CLASS_IMAGELIB ImageBase {
protected:
	unsigned int _width;
	unsigned int _height;
	unsigned int _channelCount;
	unsigned int _channelDepth;
	FILE *_fp;
public:
	ImageBase(unsigned int width = 0, unsigned int height = 0, unsigned int channelCount = 4, unsigned int channelDepth = 16) : 
	  _width(width), _height(height), _channelCount(channelCount), _channelDepth(channelDepth), _fp(0) {};
	~ImageBase() { if (_fp) fclose(_fp); }
	unsigned int GetWidth() const { return _width; }
	unsigned int GetHeight() const { return _height; }
	unsigned int GetChannelCount() const { return _channelCount; }
	unsigned int GetChannelDepth() const { return _channelDepth; }
	ImageRow GetImageRow() const { return ImageRow(_width, _channelCount, _channelDepth); }
};


class EXT_CLASS_IMAGELIB ImageReader : public ImageBase {
public:
	virtual void Open(const std::string &fileName) = 0;
	virtual void Close() = 0;
	virtual void ReadNextRow(ImageRow &row) = 0;
};
typedef std::shared_ptr<ImageReader> ImageReaderPtr;




class EXT_CLASS_IMAGELIB ImageWriter : public ImageBase {
public:
	virtual void Open(const std::string &fileName, unsigned int width, unsigned int height, unsigned int channelCount, unsigned int channelDepth) = 0;
	virtual void Close() = 0;
	virtual void WriteRow(const ImageRow &row) = 0;
};
typedef std::shared_ptr<ImageWriter> ImageWriterPtr;


#endif
