#ifndef __TESTRUNNER_H__
#define __TESTRUNNER_H__

#include <sstream>
#include <stdexcept>
#include <map>
#include <iostream>

std::string TrimPath(const std::string &path) {
	int i = path.find_last_of('\\');  // need to flip for UNIX
	return (i == std::string::npos)?path:path.substr(i+1);
}

// either this or a specialization of assertEqual for unsigned char
std::ostream &operator<<(std::ostream &os, const unsigned char &c) {
	os << (const unsigned int)c;
	return os;
}

template <typename E, typename A>
void assertEqual(const char *file, int line, const E &expected, const A &actual) {
	if (expected != actual) {
		std::stringstream s;
		s << "Assertion failed: (" << expected << ") != (" << actual << ") at " << TrimPath(file).c_str() << ":" << line;
		throw std::runtime_error(s.str());
	}
}
#define ASSERT_EQUAL(E,A) assertEqual(__FILE__, __LINE__, E, A)


void assertFail(const char *file, int line) {
	std::stringstream s;
	s << "Fail at " << TrimPath(file).c_str() << ":" << line;
	throw std::runtime_error(s.str());
}
#define ASSERT_FAIL() assertFail(__FILE__, __LINE__)


void assertTrue(const char *file, int line, bool b) {
	if (!b) {
		std::stringstream s;
		s << "Assertion failed: false when expected true at " << TrimPath(file).c_str() << ":" << line;
		throw std::runtime_error(s.str());
	}
}
#define ASSERT_TRUE(b) assertTrue(__FILE__, __LINE__, b)



typedef void(*TestFn)();

class TestRunner {
	std::map<std::string, TestFn> _tests;

public:
	void Add(const std::string &name, TestFn test) { _tests[name] = test; }

	void Run() {
		for (std::map<std::string, TestFn>::iterator i=_tests.begin(); i!=_tests.end(); i++) {
			try {
				i->second();
			} catch(std::exception &e) {
				std::cout << i->first.c_str() << "> " << e.what() << std::endl;
			}
		}
	}
};


#define ADD_TEST(r, fn) r.Add(#fn, fn);

#endif
