#include "FileManagement.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <stdexcept>

#ifdef WIN32
#include <windows.h>
#else
#include <sys/stat.h>
#include <sys/types.h>
#endif

std::string FileManagement::PathSep() {
#ifdef WIN32
	return "\\";
#else
	return "/";
#endif
}

bool FileManagement::Copy(const std::string &srcFileName, const std::string &destFileName) {
	// http://www.softwareandfinance.com/CPP/Copying_Binary_Files.html
  std::ifstream src(srcFileName.c_str(), std::ios::binary | std::ios::in);
  std::ofstream dest(destFileName.c_str(), std::ios::binary | std::ios::out);

    if (!src.is_open() || !dest.is_open())
        return false;

	const int bufSize = 4096;
    char buf[bufSize];

    while (true) {
        if (src.eof())
            break;
        src.read(buf, bufSize);
        std::streamsize nBytesRead = src.gcount();
        if (nBytesRead <= 0)
            break;
        dest.write(buf, nBytesRead);
    }

    src.close();
    dest.close();
    return true;
}


std::string FileManagement::GetBasename(const std::string &fileName) {
	std::string::size_type i = fileName.find_last_of(PathSep());
	std::string name = fileName.substr((i == std::string::npos)?0:i+1);
	i = name.find_last_of('.');
	if (i == std::string::npos)
		return name;
	return name.substr(0, i);
}


void FileManagement::CreateDir(const std::string &dirName) {
#ifdef WIN32
	::CreateDirectory(dirName.c_str(), NULL);
#else
	mkdir(dirName.c_str(), 0777);
#endif
}

