#ifndef __IMAGEBUILDER_H__
#define __IMAGEBUILDER_H__

#include "PNGReader.h"
#include "PNGWriter.h"
#include "JPEGReader.h"
#include "JPEGWriter.h"
#include <memory>

class EXT_CLASS_IMAGELIB ImageBuilder;

typedef std::shared_ptr<ImageBuilder> ImageBuilderPtr;

class EXT_CLASS_IMAGELIB ImageBuilder {
public:
	virtual ImageReaderPtr GetReader() const = 0;
	virtual ImageWriterPtr GetWriter() const = 0;
	static ImageBuilderPtr GetImageBuilder(const std::string &fileName);
	virtual std::string GetExtension() const = 0;
};

class EXT_CLASS_IMAGELIB PNGBuilder : public ImageBuilder {
public:
	ImageReaderPtr GetReader() const { return ImageReaderPtr(new PNGReader()); }
	ImageWriterPtr GetWriter() const { return ImageWriterPtr(new PNGWriter()); }
	std::string GetExtension() const { return ".png"; }
};

class EXT_CLASS_IMAGELIB JPEGBuilder : public ImageBuilder {
public:
	ImageReaderPtr GetReader() const { return ImageReaderPtr(new JPEGReader()); }
	ImageWriterPtr GetWriter() const { return ImageWriterPtr(new JPEGWriter()); }
	std::string GetExtension() const { return ".jpg"; }
};

#endif
