/*
 * $Id: DataReaderListenerImpl.h 5112 2011-12-01 19:29:24Z schmitzj $
 *
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#ifndef DATAREADER_LISTENER_IMPL_H
#define DATAREADER_LISTENER_IMPL_H

#include <tools/modeling/codegen/model/NullReaderListener.h>
#include <ace/Global_Macros.h>

#include <dds/DdsDcpsSubscriptionS.h>
#include <dds/DCPS/LocalObject.h>
#include <dds/DCPS/Definitions.h>
#include "MessageEngine_DdsUtil_Export.h"

//#ifdef _WIN32
//	#ifdef MESSAGEENGINE_DDSUTIL_BUILD_DLL
//		#define EXT_CLASS_DDSUTIL __declspec(dllexport) 
//	#else
//		#define EXT_CLASS_DDSUTIL __declspec(dllimport) 
//	#endif
//#else
//#define  EXT_CLASS_DDSUTIL
//#endif

using OpenDDS::Model::NullReaderListener;

class MessageEngine_DdsUtil_Export DataReaderListenerImpl
  : public virtual OpenDDS::DCPS::LocalObject<NullReaderListener> {
public:
  DataReaderListenerImpl();

  virtual void on_data_available(
    DDS::DataReader_ptr reader)
  ACE_THROW_SPEC((CORBA::SystemException));

  virtual void on_liveliness_changed(
	  DDS::DataReader*,
	  const DDS::LivelinessChangedStatus& status);

  long getAliveCount() const;


  int sample_count;

private:
	long aliveCount_;


};


inline
long DataReaderListenerImpl::getAliveCount() const {
	return aliveCount_;
}


#endif /* DATAREADER_LISTENER_IMPL_H */
