#pragma once

#include "MessageEngineTypeSupportImpl.h"
#include "MessageEngine_DdsUtil_Export.h"
#include <dds/DCPS/Marked_Default_Qos.h>

class MessageEngine_DdsUtil_Export DDSPublisherFacade
{
public:
	DDSPublisherFacade(DDS::DomainParticipantFactory_ptr factory,
		      DDS::DomainId_t domain, 
			  const char* topicName);
	virtual ~DDSPublisherFacade(void);

	DDS::ReturnCode_t write(Messenger::Message& message);
	Messenger::MessageDataWriter_var getDataWriter();
	void cleanup();

protected:
	void createParticipant(DDS::DomainId_t domain);
	DDS::Topic_var createTopic(const char* topicName);
	DDS::Publisher_var  createPublisher();
    Messenger::MessageDataWriter_var createDataWriter();

private:
	DDS::DomainParticipantFactory_ptr factory_;
	DDS::DomainParticipant_ptr participant_;
	DDS::Topic_ptr topic_;
	DDS::Publisher_ptr publisher_;
	Messenger::MessageDataWriter_var messageWriter_;
};

