/*
 * $Id: DeviceSimulation.h 5112 2011-12-01 19:29:24Z schmitzj $
 *
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */

#ifndef DEVICE_SIMULATION_H
#define DEVICE_SIMULATION_H

#include <tools/modeling/codegen/model/NullReaderListener.h>
#include <ace/Global_Macros.h>

#include <dds/DdsDcpsSubscriptionS.h>
#include <dds/DCPS/LocalObject.h>
#include <dds/DCPS/Definitions.h>
#include "MessageEngineTypeSupportImpl.h"
#include "DDSPublisherFacade.h"

using OpenDDS::Model::NullReaderListener;

class DeviceSimulation
  : public virtual OpenDDS::DCPS::LocalObject<NullReaderListener> {
public:
  DeviceSimulation(const char* device_id, 
	               DDSPublisherFacade* publisher,
				   int publication_period = 30);

  virtual ~DeviceSimulation();

  virtual void on_data_available(
    DDS::DataReader_ptr reader)
  ACE_THROW_SPEC((CORBA::SystemException));

  virtual void on_liveliness_changed(
	  DDS::DataReader*,
	  const DDS::LivelinessChangedStatus& status);

  long getAliveCount() const;

  // Parse the message from DDS and process all commands
  virtual bool parseMessage(
	  const Messenger::Message& message);

  // Deterine if the specified command with one float arg was received
  virtual bool parseCommand(
	  const Messenger::Message& message, 
	  std::string& command_name, 
	  float& float_arg);
  
  // Deterine if the specified command with no args was received
  virtual bool parseCommand(
	  const Messenger::Message& message, 
	  std::string& command_name) ;

  // Execute the command received from the specified source issuing the command
  // with no arguments
  virtual bool executeCommandNoArgs(
	  const char* command_source, 
	  const char* command_name);

  // Execute the command received from the specified source issuing the command
  // Passing the single argument
  virtual bool executeCommandOneArg(
	  const char* command_source, 
	  const char* command_name, 
	  float command_arg);

  virtual DDS::ReturnCode_t sendCommandResponse(
	  const char* command_source,
	  const char* command_name,
	  const char* command_response);

  // Acknowledge the receipt of the command to the source
  virtual DDS::ReturnCode_t acknowledgeCommand(
	  const char* command_source, 
	  const char* command_name);

  virtual DDS::ReturnCode_t rejectCommand(
	  const char* command_source,
	  const char* command_name,
	  const char* reason);

  virtual DDS::ReturnCode_t sendStatus();

  virtual DDS::ReturnCode_t sendMessage(const char* source,
	  const char* subject,
	  const char* text);

  int getPublicationPeriod() { return publicationPeriod_; }

  // Initiates activity in the device, updating the pressure and 
  // sending it out periodically.
  virtual void run();
  virtual void stop();

	static DeviceSimulation* deviceWorker_;

private:

	void updateTemperature();

	long aliveCount_;
	  int sample_count;
	Messenger::Message message_;
	DDSPublisherFacade* publisher_;

	// Device presure value
	float pressure_;
	// Device temperature value
	float temperature_;
	std::string deviceId_;
	int threadGroup_;
	int publicationPeriod_;
};


inline
long DeviceSimulation::getAliveCount() const {
	return aliveCount_;
}


#endif /* DEVICE_SIMULATION_H */
