/*

*/

#include "DeviceSimulation.h"
#include "DDSFilteredSubscriberFacade.h"
#include "DDSPublisherFacade.h"
#include <dds/DCPS/Service_Participant.h>
#include <model/Sync.h>
#include <stdexcept>
#include <ace/signal.h>
#include <ace/Sig_Handler.h>
#include <ace/Signal.h>

#ifdef ACE_AS_STATIC_LIBS
#include <dds/DCPS/transport/tcp/Tcp.h>
#endif

using namespace examples::boilerplate;


class DeviceSignalHandler : public ACE_Event_Handler
{
public:
	DeviceSignalHandler (DeviceSimulation* device) : device_(device), done_(false)
	{ }

	virtual ~DeviceSignalHandler ()
	{ device_ = 0; }

	virtual int handle_signal (int signum, siginfo_t * = 0, ucontext_t * = 0)
	{
		ACE_TRACE (ACE_TEXT ("DeviceSignalHandler::handle_signal"));

		if(device_ != 0)
		{
			device_->stop();
			done_ = true;
		}

		return 0;
	}
	bool getDone() const { return done_; }

private:
	DeviceSimulation* device_;
	bool done_;
};

int
	ACE_TMAIN(int argc, ACE_TCHAR *argv[])
{
	try {


		// Initialize DomainParticipantFactory, handling command line args
		DDS::DomainParticipantFactory_ptr dpf =
			TheParticipantFactoryWithArgs (argc, argv);

		std::string device_name;
		int publication_period;

		if(argc != 3)
		{
			std::cerr << "usage: device_main <device_id> <publication_period>" << std::endl; 
			exit(-1);
		}
		else 
		{
			device_name =argv[1];
			publication_period = atoi(argv[2]);
		}

		const DDS::DomainId_t domain = 42;

		//This publisher is used to send messages from Enterprise Message Clients
		const char* deviceTopic = "DeviceMessages";

		DDSPublisherFacade publisher (dpf, domain, deviceTopic);

		// This subscriber is created so this client can receive messages from XMPP clients
		const char* command_topic = "CommandMessages";

		DeviceSimulation* device = new DeviceSimulation (device_name.c_str(), 
			                                             &publisher,
														 publication_period);

		// Create a Subscriber and listener for messages coming from XMPP
		/* Instantiate a DataReaderListener to use for the subscriber */
		DDS::DataReaderListener_ptr  xmpp_messages_listener(device);

		// Construct a filter for the messages to ensure only commands that are targeted
		// to this device will be published to it.
		// Commands will be of the form   "cmd: device_id->command_name arg"
		//                             or "cmd: who"
		char command_filter[100];
		::sprintf (command_filter, 
			"(text like 'cmd:%%%s->%%') OR (text like 'cmd:%%who')", 
			device_name.c_str());

		/* Create a subscriber for receiving this clients' commands */
		DDSFilteredSubscriberFacade xmpp_messages_sub_facade(
			dpf,
			domain,
			command_topic, 
			command_filter, 
			xmpp_messages_listener);
	
			DeviceSignalHandler signal_handler (device);
			ACE_Sig_Handlers handler;
			handler.register_handler (SIGINT, &signal_handler);

			device->run();

			// Block until reader has associated with a writer
			// And exit when no readers are associated the writer
			//		OpenDDS::Model::ReaderSync rs(xmpp_messages_sub_facade.getDataReader());

			// Wait for a SIGINT signal to indicate when we are done
			while(!signal_handler.getDone ())
			{
				ACE_OS::sleep(1);
			}
		

		// Listener will be cleaned up when reader goes out of scope
	} catch (const CORBA::Exception& e) {
		e._tao_print_exception("Exception caught in main():");
		return -1;
	} catch (std::runtime_error& err) {
		ACE_ERROR_RETURN((LM_ERROR, ACE_TEXT("ERROR: main() - %s\n"),
			err.what()), -1);
	} catch (std::string& msg) {
		ACE_ERROR_RETURN((LM_ERROR, ACE_TEXT("ERROR: main() - %s\n"),
			msg.c_str()), -1);
	}

	TheServiceParticipant->shutdown ();

	return 0;
}
