#pragma once

#include "MessageEngineTypeSupportImpl.h"
#include <dds/DCPS/Marked_Default_Qos.h>
#include "Boilerplate.h"
#include "MessageEngine_DdsUtil_Export.h"

class MessageEngine_DdsUtil_Export DDSFilteredSubscriberFacade
{
public:
	DDSFilteredSubscriberFacade(DDS::DomainParticipantFactory_ptr factory,
		      DDS::DomainId_t domain, 
			  const char* topicName,
			  const char* topicFilter,
			  DDS::DataReaderListener_var listener);
	virtual ~DDSFilteredSubscriberFacade(void);

	DDS::DataReader_var getDataReader() const;
	void cleanup();

protected:
	void createParticipant(DDS::DomainId_t domain);
	DDS::DataReader_var createDataReader();
	DDS::Topic_var createTopic(const char* topicName, const char* topicFilter);
	DDS::Subscriber_var createSubscriber();

private:
	DDS::DomainParticipantFactory_ptr factory_;
	DDS::DomainParticipant_ptr participant_;
	DDS::Topic_ptr topic_;
	DDS::ContentFilteredTopic_var filteredTopic_;
	DDS::Subscriber_ptr subscriber_;
	DDS::DataReader_var dataReader_;
	DDS::DataReaderListener_var listener_;
};

