#pragma once

#include "MessageEngineTypeSupportImpl.h"
#include <dds/DCPS/Marked_Default_Qos.h>
#include "Boilerplate.h"
#include "MessageEngine_DdsUtil_Export.h"

class MessageEngine_DdsUtil_Export DDSSubscriberFacade
{
public:
	DDSSubscriberFacade(DDS::DomainParticipantFactory_ptr factory,
		      DDS::DomainId_t domain, 
			  const char* topicName,
			  DDS::DataReaderListener_var listener);
	virtual ~DDSSubscriberFacade(void);

	DDS::DataReader_var getDataReader() const;
	void cleanup();

protected:
	void createParticipant(DDS::DomainId_t domain);
	DDS::DataReader_var createDataReader();
	DDS::Topic_var createTopic(const char* topicName);
	DDS::Subscriber_var createSubscriber();

private:
	DDS::DomainParticipantFactory_ptr factory_;
	DDS::DomainParticipant_var participant_;
	DDS::Topic_var topic_;
	DDS::Subscriber_var subscriber_;
	DDS::DataReader_var dataReader_;
	DDS::DataReaderListener_var listener_;
};

