// ftchat.cpp : Defines the entry point for the console application.
#include <iostream>
#include <boost/bind.hpp>
#include "MessageEngine.h"
#include "MessageEngineComponent.h"

#include <Swiften/Swiften.h>

using namespace Swift;
using namespace boost;

void usage() {
  std::cout 
    << "-u userid   : Jabber ID used by gateway to login to XMPP server\n"
    << "-p password : Gateway password for XMPP server\n"
	<< "-r roomname : JabberID for the chat room (room@conference.domain.com)\n"
    << "-verbose    : Turn on verbose logging to console\n"
	<< "-trace      : Turn on XMPP tracing\n"
	<< "-DCPSConfigFile filename : Config file used by OpenDDS participants"
    << std::endl;

}

int main(int argc, char** argv) {

	bool verbose = false;
	bool trace = false;
	bool initDDS = true;
	std::string uid = "default";
	std::string pwd = "default";
	std::string host = "default";
	std::string room = "default";

	// Process command line args
	int i = 0;
	while (i < argc) {

	if (std::string(argv[i]) == "-u" ) {
		uid.clear();
		uid.append(argv[++i]);
	} else if (std::string(argv[i]) == "-p" ) {
		pwd.clear();
		pwd.append(argv[++i]);
	} else if (std::string(argv[i]) == "-r" ) {
		room.clear();
		room.append(argv[++i]);
    } else if (std::string(argv[i]) == "-verbose" ) {
		verbose = true;
		std::cout << "Enabling verbose output" << std::endl;
    } else if (std::string(argv[i]) == "-trace" ) {
		trace = true;
		std::cout << "Enabling trace output" << std::endl;
    } else if (std::string(argv[i]) == "-?" ) {
		usage();
      return 0;
    }
    ++i;
  }
  SimpleEventLoop eventLoop;
  BoostNetworkFactories networkFactories(&eventLoop);

  //Create a PubSubHandler to use in our MessageEngineComponent



  MessageEngineComponent ems(verbose);

 // Call initXMPP on the message engine component to startup the XMPP client connection.

  int err;
  err= ems.initXMPP(&eventLoop,&networkFactories, uid, pwd, room, verbose, trace);
  if (err != 0) {
	  std::cout << "Error occurred in XMPP startup with [" << err << "]...check log for errors." << std::endl;
	  return -1;
  }

  

  // Call initDDS on the message engine component to startup the OpenDDS connection.

  if (initDDS) {
	 err= ems.initDDS(argc, argv);
	 if (err != 0) {
		  std::cout << "Error occurred in OpenDDS startup[" << err << "]...check log for errors." << std::endl;
		  return -1;
	  }
  }



  
  eventLoop.run();


  return 0;
}
