#ifndef MESSAGEENGINEDDSDATALISTENERIMPL_H
#define MESSAGEENGINEDDSDATALISTENERIMPL_H
#include <Swiften/Swiften.h>
#include <dds/DdsDcpsSubscriptionS.h>

//using namespace Swift;

class MessageEngineDDSDataListenerImpl
	: public virtual OpenDDS::DCPS::LocalObject<DDS::DataReaderListener> {
public:
	Swift::JID jid;
	int sample_count;
	Swift::Client* localClient_ ;

	MessageEngineDDSDataListenerImpl();
	MessageEngineDDSDataListenerImpl(Swift::Client* targetClient, std::string aRoom, bool verbose);

	virtual ~MessageEngineDDSDataListenerImpl();

	void onJoinComplete();
	virtual void on_data_available(DDS::DataReader* reader);
	virtual void on_requested_deadline_missed(
		DDS::DataReader* reader,
		const DDS::RequestedDeadlineMissedStatus& status)
	{
		// stubbed
	}

	virtual void on_requested_incompatible_qos(
		DDS::DataReader* reader,
		const DDS::RequestedIncompatibleQosStatus& status)
	{
		// stubbed
	}

	virtual void on_liveliness_changed(
		DDS::DataReader* reader,
		const DDS::LivelinessChangedStatus& status);

	virtual void on_subscription_matched(
		DDS::DataReader* reader,
		const DDS::SubscriptionMatchedStatus& status)
	{
		// stubbed
	}
	virtual void on_sample_rejected(
		DDS::DataReader* reader,
		const DDS::SampleRejectedStatus& status)
	{
		// stubbed
	}
	virtual void on_sample_lost(
		DDS::DataReader* reader,
		const DDS::SampleLostStatus& status)
	{
		// stubbed
	}
private:
	long aliveCount_;
	std::string localRoom_;
	bool verbose_;

};

#endif