#ifndef MESSAGEENGINECOMPONENT_H
#define MESSAGEENGINECOMPONENT_H
#include <Swiften/Swiften.h>
#include "ddsutil/DDSPublisherFacade.h"     // OpenDDS Publisher support
#include "ddsutil/DDSSubscriberFacade.h"    // OpenDDS Subscriber support
#include "ddsutil/DDSFilteredSubscriberFacade.h"    // OpenDDS Subscriber support


using namespace Swift;

class MessageEngineComponent
{
public:
	Swift::JID jid;
	Swift::Client * XMPPclient_;
	Swift::MUC::ref XMPPMUChandle_;

	Swift::ClientXMLTracer* tracer;


	 MessageEngineComponent(bool verbose);


	 ~MessageEngineComponent();

	 int initDDS(int argc, char * argv[]);
     int initXMPP(SimpleEventLoop * ev, 
		                    NetworkFactories * nwf, 
							std::string uid, 
							std::string pwd,
							std::string room,
							bool verbose, 
							bool trace);

	 void setPresence(bool presence);


private:
	bool present_;
	bool verbose_;
	bool joined_;
	bool trace_;
	std::string localRoom_;
	DDSPublisherFacade * publisher_;
	DDSSubscriberFacade * subscriber_;


    void handleConnected();
	void handleDataRead(const SafeByteArray& data);
	void handleDataWritten(const SafeByteArray& data);
	void handleJoinComplete(const std::string& nick);
    void handleMessageReceived(Swift::Message::ref message);
	void handlePresenceReceived(Swift::Presence::ref presence);
	void handleRosterReceived(Swift::ErrorPayload::ref error);
};

#endif