
@REM Copyright (c) 2009, 2010 Object Computing, Inc.
@REM All rights reserved.
@REM See the file license.txt for licensing information.

REM Setting up Message Engine environment

@REM This setup script assumes the following:
@REM 1. The MessageEngine source is unzipped in C:\dev\messageengine
@REM 2. OpenSSL is installed in C:\OpenSSL-Win32
@REM 3. ACE, TAO, MPC is installed and built in C:\ACE_wrappers
@REM 4. OpenDDS is installed and built in C:\DDS
@REM 5. Swift is installed and built in c:\dev\tools\Swift
@REM 6. Boost is installed in C:\dev\tools\boost

@REM Customize this file by setting variables to suit your environment
@REM Delete the following line when you finishing customizing this file.
@echo See remarks in %0 for information about setting your build environment
@echo off

REM ACE, TAO, MPC, OpenDDS ENVIRONMENT
REM =====================================================================================
REM EDIT THE FOLLOWING LINES OR SET THESE VALUES IN YOUR ENVIRONMENT BEFORE RUNNING SETUP

   if "a" == "a%ACE_ROOT%" set ACE_ROOT=c:\ACE_wrappers
   if "a" == "a%TAO_ROOT%" set TAO_ROOT=%ACE_ROOT%\tao
   if "a" == "a%MPC_ROOT%" set MPC_ROOT=%ACE_ROOT%\MPC
   if "a" == "a%DDS_ROOT%" set DDS_ROOT=c:\DDS
   
   set PATH=.;%ACE_ROOT%\bin;%ACE_ROOT%\lib;%DDS_ROOT%\bin;%DDS_ROOT%\lib;%PATH%


REM Boost ENVIRONMENT
REM =====================================================================================
REM EDIT THE FOLLOWING LINES OR SET THESE VALUES IN YOUR ENVIRONMENT BEFORE RUNNING SETUP   
   if "a" == "a%BOOST_ROOT%" set BOOST_ROOT=c:\dev\tools\boost\boost_1_47
   if "a" == "a%BOOST_ROOT_LIB%" set BOOST_ROOT_LIB=%BOOST_ROOT%\lib
   if "a" == "a%BOOST_CFG%" set BOOST_CFG=-vc100-mt-gd-1_47
   if "a" == "a%BOOST_VERSION%" set BOOST_VERSION=boost-1_47
   set PATH=%BOOST_ROOT_LIB%;%PATH%

REM Swift ENVIRONMENT
REM =====================================================================================
REM EDIT THE FOLLOWING LINES OR SET THESE VALUES IN YOUR ENVIRONMENT BEFORE RUNNING SETUP

if "a" == "a%SWIFT_ROOT%" set SWIFT_ROOT=c:\dev\tools\Swift

set PATH=%PATH%;%SWIFT_ROOT%\Swiften

REM OpenSSL ENVIRONMENT
REM =====================================================================================
REM EDIT THE FOLLOWING LINES OR SET THESE VALUES IN YOUR ENVIRONMENT BEFORE RUNNING SETUP

if "a" == "a%SSL_ROOT%" set SSL_ROOT=C:\OpenSSL-Win32


REM Message Engine Project
REM =====================================================================================
REM EDIT THE FOLLOWING LINES OR SET THESE VALUES IN YOUR ENVIRONMENT BEFORE RUNNING SETUP

if "a" == "a%ME_ROOT%" set ME_ROOT=C:\dev\messageengine
if "a" == "a%INFOREPO_HOST%" set INFOREPO_HOST=localhost

set PATH=%ME_ROOT%\bin;%ME_ROOT%\lib;%PATH%

 
 
REM Microsoft moved 32 bit apps to a new program files directory on 64 bit systems
set PROGRAM_FILES_X86=Program Files
if exist "C:\Program Files (x86)" set PROGRAM_FILES_X86=Program Files (x86)

REM Verify setup by checking for expected files/directories
set SETUP_CHECKING=MPC_ROOT=%MPC_ROOT%
if not exist "%MPC_ROOT%\mpc.pl" goto setup_is_bad

set SETUP_CHECKING=SWIFT_ROOT=%SWIFT_ROOT%
if not exist "%SWIFT_ROOT%\Swift" goto setup_is_bad

set SETUP_CHECKING=SSL_ROOT=%SSL_ROOT%
if not exist "%SSL_ROOT%" goto setup_is_bad

set SETUP_CHECKING=BOOST_ROOT=%BOOST_ROOT%
if not exist "%BOOST_ROOT%\boost" goto setup_is_bad

set SETUP_CHECKING=BOOST_ROOT_LIB=%BOOST_ROOT%\lib
if not exist "%BOOST_ROOT%\lib" goto setup_is_bad

set SETUP_CHECKING=ME_ROOT=%ME_ROOT%
if not exist "%ME_ROOT%" goto setup_is_bad

REM Find visual studio.  
REM You can short-circuit this by setting VCVER before running this
REM However this also avoids the check to see if VC is installed in the expected place.
set SETUP_CHECKING=Setup checking visual studio common tools
if not "a" == "a%VCVER%" goto setup_is_ok
set VCVER=10
set SETUP_CHECKING=VS100COMNTOOLS=%VS100COMNTOOLS%
if exist "%VS100COMNTOOLS%VSVARS32.BAT" goto setup_is_ok
set VCVER=9
set SETUP_CHECKING=VS90COMNTOOLS=%VS90COMNTOOLS%
if exist "%VS90COMNTOOLS%VSVARS32.BAT" goto setup_is_ok
set VCVER=8
set SETUP_CHECKING=VS80COMNTOOLS=%VS80COMNTOOLS%
if exist "%VS80COMNTOOLS%VSVARS32.BAT" goto setup_is_ok
REM goto setup_is_bad  (you are here) 

:setup_is_bad
ECHO Setup check failed: %SETUP_CHECKING%
ECHO Edit the setup.cmd file or change environment variables
goto end

:setup_is_ok
set SETUP_CHECKING=


rem must be outside the if because of the parens in the directory name [what was microsoft thinking?]
if %VCVER%==10 goto isVC10
if %VCVER%==9 goto isVC9
if %VCVER%==8 goto isVC8
echo "UNKNOWN OR UNSUPPORTED VISUAL STUDIO VERSION: %VCVER%
goto end

:isVC10
set VC_ROOT=C:\%PROGRAM_FILES_X86%\Microsoft Visual Studio 10.0\VC\bin
@call "%VS100COMNTOOLS%VSVARS32.BAT" >nul
goto vcIsSet
:isVC9
set VC_ROOT=C:\%PROGRAM_FILES_X86%\Microsoft Visual Studio 9.0\VC\bin
call "%VS90COMNTOOLS%VSVARS32.BAT" >nul
goto vcIsSet
:isVC8
set VC_ROOT=C:\%PROGRAM_FILES_X86%\Microsoft Visual Studio 8\VC\bin
call "%VS80COMNTOOLS%VSVARS32.BAT" >nul
:vcIsSet

REM: This avoids growing PATH and INCLUDE every time setup is run
if "a" == "a%BASE_PATH%" set BASE_PATH=%PATH%
if "a" == "a%BASE_INCLUDE%" set BASE_INCLUDE=%INCLUDE%



REM title MessageEngine
:end


