/*
 * $Id: Boilerplate.cpp 5112 2011-12-01 19:29:24Z schmitzj $
 *
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */
 
#include "Boilerplate.h"
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/Service_Participant.h>

namespace examples { namespace boilerplate {



Messenger::MessageDataWriter_var
narrow(DDS::DataWriter_var writer)
{
  // Safe cast to type-specific data writer
  Messenger::MessageDataWriter_var message_writer =
    Messenger::MessageDataWriter::_narrow(writer);

  // Check for failure
  if (!message_writer) {
    throw std::string("failed to narrow data writer");
  }

  return message_writer;
}

Messenger::MessageDataReader_var
narrow(DDS::DataReader_var reader)
{
  // Safe cast to type-specific data reader
  Messenger::MessageDataReader_var message_reader =
    Messenger::MessageDataReader::_narrow(reader);

  // Check for failure
  if (!message_reader) {
    throw std::string("failed to narrow data reader");
  }

  return message_reader;
}

Messenger::MessageDataWriter_var
narrow(DDS::DataWriter_ptr writer)
{
  // Safe cast to type-specific data writer
  Messenger::MessageDataWriter_var message_writer =
    Messenger::MessageDataWriter::_narrow(writer);

  // Check for failure
  if (!message_writer) {
    throw std::string("failed to narrow data writer");
  }

  return message_writer;
}

Messenger::MessageDataReader_var
narrow(DDS::DataReader_ptr reader)
{
  // Safe cast to type-specific data reader
  Messenger::MessageDataReader_var message_reader =
    Messenger::MessageDataReader::_narrow(reader);

  // Check for failure
  if (!message_reader) {
    throw std::string("failed to narrow data reader");
  }

  return message_reader;
}



} } // End namespaces
