/*
 * $Id: DataReaderListenerImpl.cpp 5112 2011-12-01 19:29:24Z schmitzj $
 *
 *
 * Distributed under the OpenDDS License.
 * See: http://www.opendds.org/license.html
 */
#include "MessageEngineDDSDataListenerImpl.h"
#include "ddsutil/Boilerplate.h"
#include <Swiften/Swiften.h>


MessageEngineDDSDataListenerImpl::MessageEngineDDSDataListenerImpl() : sample_count(0), aliveCount_(0)
{
}

MessageEngineDDSDataListenerImpl::MessageEngineDDSDataListenerImpl(Swift::Client* targetClient, 
																	 std::string aRoom,
																	 bool verbose) 
	: sample_count(0), aliveCount_(0), localRoom_("default"),verbose_(false)
{
	localClient_ = targetClient;
	localRoom_ = aRoom;
	verbose_ = verbose;
}
void
MessageEngineDDSDataListenerImpl::on_data_available(DDS::DataReader_ptr reader)
ACE_THROW_SPEC((CORBA::SystemException))
{
  // Safely downcast data reader to type-specific data reader
  Messenger::MessageDataReader_var reader_i = Messenger::MessageDataReader::_narrow(reader);

  Messenger::Message msg;
  DDS::SampleInfo info;

  // Remove (take) the next sample from the data reader
  DDS::ReturnCode_t error = reader_i->take_next_sample(msg, info);

  // Make sure take was successful
  if (error == DDS::RETCODE_OK) {
    // Make sure this is not a sample dispose message

	  if (verbose_) {
		  std::cout << "Sample taken ok..." << std::endl;
	  }

    if (info.valid_data) {
      ++sample_count;

	  // Create a new XMPP Message for the payload of the message
         // The Swift library creates a new stanza based on this type

	  boost::shared_ptr<Swift::Message> xmppMsg(new Swift::Message());

         // Set the type of message to Groupchat so that the XMPP server will
         // properly allow the message to be used in a Multi-User session 
	  xmppMsg->setType(Swift::Message::Type::Groupchat);

         // Since this message engine handles messages for more than one device,
         // append the sender to the front of the message text so those in the
         // chat room can see which device it is from.

	  std::string localMsg_;
	  xmppMsg->setBody(localMsg_.append("[").append(msg.from.in()).append("] ").append("[").append(msg.subject.in()).append("]").append(msg.text.in()));

         // Populate the from and to fields of the stanza 

	  xmppMsg->setFrom(localClient_->getJID());
	  xmppMsg->setTo(localRoom_);

         // Now send the message to the XMPP server

	  localClient_->sendMessage(xmppMsg);

         // Log the message coming from the device if verbosity is turned on
	  
	  if (verbose_) {
      std::cout << "Msg: subject    " << msg.subject.in() << std::endl
                << "     subject_id " << msg.subject_id   << std::endl
                << "     from       " << msg.from.in()    << std::endl
                << "     count      " << msg.count        << std::endl
                << "     text       " << msg.text.in()    << std::endl;
	  }
    }
  } else {
    ACE_ERROR((LM_ERROR,
               ACE_TEXT("ERROR: %N:%l: on_data_available() -")
               ACE_TEXT(" take_next_sample failed!\n")));
  }
}


MessageEngineDDSDataListenerImpl::~MessageEngineDDSDataListenerImpl(){}

void 
MessageEngineDDSDataListenerImpl::on_liveliness_changed(DDS::DataReader* dr,
										 const DDS::LivelinessChangedStatus& status)
{
	
	  // Create a new XMPP Message to indicate how many devices are reporting.
	  boost::shared_ptr<Swift::Message> xmppMsg(new Swift::Message());

         // Set the type of message to Groupchat so that the XMPP server will
         // properly allow the message to be used in a Multi-User session 
	  xmppMsg->setType(Swift::Message::Type::Groupchat);

         // Populate the from and to fields of the stanza 

	  xmppMsg->setFrom(localClient_->getJID());
	  xmppMsg->setTo(localRoom_);

	  std::ostringstream localMsg_ (std::ostringstream::out);


	if (status.alive_count > 0) {
		localMsg_ << status.alive_count << ((status.alive_count == 1) ? " device is in the room" : " devices are in the room...");
		xmppMsg->setBody(localMsg_.str());

	} else {
			xmppMsg->setBody("No devices are in the room...");
	}

      // Now send the message to the XMPP server
	  localClient_->sendMessage(xmppMsg);

   if(verbose_) {

		std::cout << "Liveliness: alive = " << status.alive_count << " not_alive = " << status.not_alive_count
			<< " alive change = " << status.alive_count_change << " not alive count change = " << status.not_alive_count << 
			std::endl;

		aliveCount_ = status.alive_count;
   }

}