/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.component;

import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.component.AnnotatedContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConstructor<T> {
    private final InjectableProviderContext ipc;
    private final Class<T> c;
    private final Method postConstruct;
    private final ComponentInjector<T> ci;

    public ComponentConstructor(InjectableProviderContext ipc, Class<T> c, ComponentInjector<T> ci) {
        this.ipc = ipc;
        this.c = c;
        this.ci = ci;
        this.postConstruct = ComponentConstructor.getPostConstructMethod(c);
    }

    private static Method getPostConstructMethod(Class c) {
        MethodList methodList;
        Iterator<AnnotatedMethod> i$;
        Class postConstructClass = ReflectionHelper.classForName("javax.annotation.PostConstruct");
        if (postConstructClass != null && (i$ = (methodList = new MethodList(c)).hasAnnotation(postConstructClass).hasNumParams(0).hasReturnType(Void.TYPE).iterator()).hasNext()) {
            AnnotatedMethod m = i$.next();
            return m.getMethod();
        }
        return null;
    }

    public T getInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T t = this._getInstance();
        this.ci.inject(t);
        if (this.postConstruct != null) {
            this.postConstruct.invoke(t, new Object[0]);
        }
        return t;
    }

    private T _getInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ConstructorInjectablePair<T> cip = this.getConstructor();
        if (cip == null || ((ConstructorInjectablePair)cip).is.size() == 0) {
            return this.c.newInstance();
        }
        Object[] params = new Object[((ConstructorInjectablePair)cip).is.size()];
        int i = 0;
        for (Injectable injectable : ((ConstructorInjectablePair)cip).is) {
            if (injectable == null) continue;
            params[i++] = injectable.getValue();
        }
        return ((ConstructorInjectablePair)cip).con.newInstance(params);
    }

    private ConstructorInjectablePair<T> getConstructor() {
        if (this.c.getConstructors().length == 0) {
            return null;
        }
        TreeSet cs = new TreeSet(new ConstructorComparator());
        AnnotatedContext aoc = new AnnotatedContext();
        for (Constructor<?> con : this.c.getConstructors()) {
            ArrayList<Injectable> is = new ArrayList<Injectable>();
            int ps = con.getParameterTypes().length;
            for (int p = 0; p < ps; ++p) {
                Type pgtype = con.getGenericParameterTypes()[p];
                Annotation[] as = con.getParameterAnnotations()[p];
                aoc.setAnnotations(as);
                Injectable i = null;
                for (Annotation a : as) {
                    i = this.ipc.getInjectable(a.annotationType(), (ComponentContext)aoc, a, pgtype, ComponentScope.UNDEFINED_SINGLETON);
                }
                is.add(i);
            }
            cs.add(new ConstructorInjectablePair(con, is));
        }
        return (ConstructorInjectablePair)cs.first();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorComparator<T>
    implements Comparator<ConstructorInjectablePair<T>> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(ConstructorInjectablePair<T> o1, ConstructorInjectablePair<T> o2) {
            int p = Collections.frequency(((ConstructorInjectablePair)o1).is, null) - Collections.frequency(((ConstructorInjectablePair)o2).is, null);
            if (p != 0) {
                return p;
            }
            return ((ConstructorInjectablePair)o2).con.getParameterTypes().length - ((ConstructorInjectablePair)o1).con.getParameterTypes().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorInjectablePair<T> {
        private final Constructor<T> con;
        private final List<Injectable> is;

        private ConstructorInjectablePair(Constructor<T> con, List<Injectable> is) {
            this.con = con;
            this.is = is;
        }
    }
}

