/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public abstract class TerminatingClientHandler
implements ClientHandler {
    protected static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    @Context
    private MessageBodyWorkers workers;

    protected MessageBodyWorkers getMessageBodyWorkers() {
        return this.workers;
    }

    protected String headerValueToString(Object headerValue) {
        return ClientRequest.getHeaderValue(headerValue);
    }

    protected RequestEntityWriter getRequestEntityWriter(ClientRequest ro) {
        return new RequestEntityWriterImpl(ro);
    }

    protected void writeRequestEntity(ClientRequest ro, RequestEntityWriterListener listener) throws IOException {
        Object entity = ro.getEntity();
        if (entity == null) {
            return;
        }
        Type entityType = null;
        if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            entityType = ge.getType();
            entity = ge.getEntity();
        } else {
            entityType = entity.getClass();
        }
        Class<?> entityClass = entity.getClass();
        MultivaluedMap<String, Object> metadata = ro.getMetadata();
        MediaType mediaType = null;
        Object mediaTypeHeader = metadata.getFirst((Object)"Content-Type");
        if (mediaTypeHeader instanceof MediaType) {
            mediaType = (MediaType)mediaTypeHeader;
        } else if (mediaTypeHeader != null) {
            mediaType = MediaType.valueOf((String)mediaTypeHeader.toString());
        } else {
            List mediaTypes = this.workers.getMessageBodyWriterMediaTypes(entityClass, entityType, EMPTY_ANNOTATIONS);
            mediaType = (MediaType)mediaTypes.get(0);
            if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
                mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            metadata.putSingle((Object)"Content-Type", (Object)mediaType);
        }
        MessageBodyWriter bw = this.workers.getMessageBodyWriter(entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        if (bw == null) {
            throw new ClientHandlerException("A message body writer for Java type, " + entity.getClass() + ", and MIME media type, " + mediaType + ", was not found");
        }
        long size = bw.getSize(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        listener.onRequestEntitySize(size);
        OutputStream out = ro.getAdapter().adapt(ro, listener.onGetOutputStream());
        bw.writeTo(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType, metadata, out);
        out.flush();
        out.close();
    }

    private final class RequestEntityWriterImpl
    implements RequestEntityWriter {
        private final ClientRequest cr;
        private final Object entity;
        private final Type entityType;
        private MediaType mediaType;
        private final long size;
        private final MessageBodyWriter bw;

        public RequestEntityWriterImpl(ClientRequest cr) {
            this.cr = cr;
            Object e = cr.getEntity();
            if (e == null) {
                throw new IllegalArgumentException("The entity of the client request is null");
            }
            if (e instanceof GenericEntity) {
                GenericEntity ge = (GenericEntity)e;
                this.entity = ge.getEntity();
                this.entityType = ge.getType();
            } else {
                this.entity = e;
                this.entityType = this.entity.getClass();
            }
            Class<?> entityClass = this.entity.getClass();
            MultivaluedMap<String, Object> metadata = cr.getMetadata();
            Object mediaTypeHeader = metadata.getFirst((Object)"Content-Type");
            if (mediaTypeHeader instanceof MediaType) {
                this.mediaType = (MediaType)mediaTypeHeader;
            } else if (mediaTypeHeader != null) {
                this.mediaType = MediaType.valueOf((String)mediaTypeHeader.toString());
            } else {
                List mediaTypes = TerminatingClientHandler.this.workers.getMessageBodyWriterMediaTypes(entityClass, this.entityType, EMPTY_ANNOTATIONS);
                this.mediaType = (MediaType)mediaTypes.get(0);
                if (this.mediaType.isWildcardType() || this.mediaType.isWildcardSubtype()) {
                    this.mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
                metadata.putSingle((Object)"Content-Type", (Object)this.mediaType);
            }
            this.bw = TerminatingClientHandler.this.workers.getMessageBodyWriter(entityClass, this.entityType, EMPTY_ANNOTATIONS, this.mediaType);
            if (this.bw == null) {
                throw new ClientHandlerException("A message body writer for Java type, " + this.entity.getClass() + ", and MIME media type, " + this.mediaType + ", was not found");
            }
            this.size = this.bw.getSize(this.entity, entityClass, this.entityType, EMPTY_ANNOTATIONS, this.mediaType);
        }

        public long getSize() {
            return this.size;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public void writeRequestEntity(OutputStream out) throws IOException {
            out = this.cr.getAdapter().adapt(this.cr, out);
            this.bw.writeTo(this.entity, this.entity.getClass(), this.entityType, EMPTY_ANNOTATIONS, this.mediaType, this.cr.getMetadata(), out);
            out.flush();
            out.close();
        }
    }

    protected static interface RequestEntityWriter {
        public long getSize();

        public MediaType getMediaType();

        public void writeRequestEntity(OutputStream var1) throws IOException;
    }

    protected static interface RequestEntityWriterListener {
        public void onRequestEntitySize(long var1) throws IOException;

        public OutputStream onGetOutputStream() throws IOException;
    }
}

