/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.core;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.server.impl.container.config.AnnotatedClassScanner;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesResourceConfig
extends DefaultResourceConfig {
    public static final String PROPERTY_PACKAGES = "com.sun.jersey.config.property.packages";
    private static final Logger LOGGER = Logger.getLogger(PackagesResourceConfig.class.getName());
    private final String[] packages;

    public PackagesResourceConfig(String ... packages) {
        if (packages == null || packages.length == 0) {
            throw new IllegalArgumentException("Array of packages must not be null or empty");
        }
        this.packages = (String[])packages.clone();
        this.init(packages);
    }

    public PackagesResourceConfig(Map<String, Object> props) {
        this(PackagesResourceConfig.getPackages(props));
        this.setPropertiesAndFeatures(props);
    }

    public void reload() {
        this.getClasses().clear();
        this.init(this.packages);
    }

    private void init(String[] packages) {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder b = new StringBuilder();
            b.append("Scanning for root resource and provider classes in the packages:");
            for (String p : packages) {
                b.append('\n').append("  ").append(p);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
        AnnotatedClassScanner scanner = new AnnotatedClassScanner(Path.class, Provider.class);
        scanner.scan(packages);
        this.getClasses().addAll(scanner.getMatchingClasses());
        if (LOGGER.isLoggable(Level.INFO) && !this.getClasses().isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Root resource classes found:");
            for (Class<?> c : this.getClasses()) {
                if (!c.isAnnotationPresent(Path.class)) continue;
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
            b = new StringBuilder();
            b.append("Provider classes found:");
            for (Class<?> c : this.getClasses()) {
                if (!c.isAnnotationPresent(Provider.class)) continue;
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
    }

    private static String[] getPackages(Map<String, Object> props) {
        Object v = props.get(PROPERTY_PACKAGES);
        if (v == null) {
            throw new IllegalArgumentException("com.sun.jersey.config.property.packages property is missing");
        }
        String[] packages = PackagesResourceConfig.getPackages(v);
        if (packages.length == 0) {
            throw new IllegalArgumentException("com.sun.jersey.config.property.packages contains no packages");
        }
        return packages;
    }

    private static String[] getPackages(Object param) {
        if (param instanceof String) {
            return PackagesResourceConfig.getElements(new String[]{(String)param});
        }
        if (param instanceof String[]) {
            return PackagesResourceConfig.getElements((String[])param);
        }
        throw new IllegalArgumentException("com.sun.jersey.config.property.packages must have a property value of type String or String[]");
    }
}

