/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Database {
    private static final String[] BASE_COURSE_NAMES = {"Java", "Python", "Ruby", "Database", "Unix", "Windows"};
    private static final String[][] INSTRUCTOR_NAMES = {{"George", "Washington", "gwash@ociweb.com"},
        {"John", "Adams", "jadams@ociweb.com"},{"Thomas", "Jefferson", "tjefferson@ociweb.com"},
        {"James", "Madison", "jmadison@ociweb.com"}, {"James", "Monroe", "jmonroe@ociweb.com"},
        {"John Quincy", "Adams", "jqadams@ociweb.com"}};
    private static final String[][] COURSE_TYPES = {{"101", "Introduction to "}, {"201", "Intermediate "}, {"301", "Advanced "}};
    private static final String[][] STUDENT_NAMES = {{"John", "Doe"}, {"Jane", "Doe"}, {"Joe", "Public"}, {"Fred", "Rogers"}};
    private Map<String, Course> courses;
    
    public Database() {
        courses = createData();
    }
    
    public List<String> getCourseList() {
        List<String> courseList = new ArrayList<String>(courses.keySet());
        
        Collections.sort(courseList);
        return courseList;
    }
    
    public Course getCourse(String courseNumber) {
        return courses.get(courseNumber);
    }
    
    public boolean addCourse(Course course) {
        String courseNumber = course.getNumber();
        if (courses.get(courseNumber) != null) {
            return false;
        }
        courses.put(courseNumber, course);
        return true;
    }
    
    public boolean deleteCourse(String courseNumber) {
        return courses.remove(courseNumber) != null;
    }
    
    private Map<String, Course> createData() {
        Map<String, Course> dataMap= new HashMap<String, Course>();
        
        int roomNumber = 100;
        
        for (int i = 0; i < BASE_COURSE_NAMES.length; i++) {
            String baseCourseName = BASE_COURSE_NAMES[i];
            for (String[] courseType : COURSE_TYPES) {
                String courseNumber = baseCourseName.toUpperCase() + "_" + courseType[0];
                String courseName = courseType[1] + baseCourseName;
                String instrFirstName = INSTRUCTOR_NAMES[i][0];
                String instrLastName = INSTRUCTOR_NAMES[i][1];
                String instrEmail = INSTRUCTOR_NAMES[i][2];
                Person instructor = new Person(i, instrFirstName, instrLastName, instrEmail, null);
                instructor.getPhones().add(new Phone(i, "", PhoneTypeEnum.WORK));
                Course course = new Course(i, courseNumber, courseName, instructor, Integer.toString(roomNumber++), null);
                
                for (String[] strudentName : STUDENT_NAMES) {
                    String firstName = strudentName[0];
                    String lastName = strudentName[1];
                    String email = firstName.toLowerCase() + "." + lastName.toLowerCase() + "@ociweb.com";
                    Person student = new Person(i, firstName, lastName, email, null);
                    course.getStudents().add(student);
                }
                
                dataMap.put(courseNumber, course);
            }
        }
        
        return dataMap;
    }
}
