/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.rest;

import java.io.IOException;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

import com.ociweb.jnb.db.Course;
import com.ociweb.jnb.db.Database;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;

public class RestServer {
    
    private static final String JERSEY_RESOURCE_CONFIG_CLASS_PARM = "com.sun.jersey.config.property.resourceConfigClass";
    private static final String JERSEY_RESOURCE_CONFIG_CLASS_NAME = PackagesResourceConfig.class.getName();
    private static final String JERSEY_PACKAGES_PARM = "com.sun.jersey.config.property.packages";
    private static final String JERSEY_PACKAGE_NAME = "com.ociweb.jnb.rest";
    
    private static Database db = new Database();

    @Path("/")
    public static class TestResource {

        @GET
        @Path("/getCourseInventory")
        @Produces({"application/xml","application/json"})
        public CourseWrapper getCourseInventory() {
            List<String> courseList = db.getCourseList();
            CourseWrapper courseWrapper = new CourseWrapper();
            courseWrapper.setCourses(courseList);
            return courseWrapper;
        }

        @GET
        @Path("/getCourse")
        @Consumes("text/plain")
        @Produces({"application/xml","application/json"})
        public JAXBElement<Course> getCourse(@QueryParam("number") String number) {
            Course dbCourse = db.getCourse(number);
            return new JAXBElement<Course>(new QName("course"), Course.class, dbCourse);
        }

        @PUT
        @Path("/addCourse")
        @Consumes({"application/xml","application/json"})
        @Produces("text/plain")
        public String addCourse(@QueryParam("course") JAXBElement<Course> course) {
            Course value = course.getValue();
            return Boolean.toString(db.addCourse(value));
        }

        @GET
        @Path("/deleteCourse")
        @Consumes("text/plain")
        @Produces("text/plain")
        public String deleteCourse(@QueryParam("number") String number) {
            return Boolean.toString(db.deleteCourse(number));
        }
    }

    public static void main(String[] args) {
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        
        sh.setInitOrder(0);
        sh.setInitParameter(JERSEY_RESOURCE_CONFIG_CLASS_PARM, JERSEY_RESOURCE_CONFIG_CLASS_NAME);
        sh.setInitParameter(JERSEY_PACKAGES_PARM, JERSEY_PACKAGE_NAME);

        Server server = new Server(8080);
        Context context = new Context(server, "/", Context.SESSIONS);
        context.addServlet(sh, "/*");
        
        System.out.println("Firing up the REST server.");
        try {
            server.start();
        } catch (final Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        
        System.out.println("Fired up the REST server. - Press <Enter> to terminate.");
        try {
            System.in.read();
            server.stop();
        } catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        } catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}
