/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.rmi;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;

public class RmiClient {

    public static void main(final String[] args) {
        if (args.length < 1) {
            System.out.println("Hostname must be passed");
            System.exit(1);
        }
        final String hostName = args[0];
        
        try {
            final Registry registry = LocateRegistry.getRegistry(hostName, RmiServer.PORT);
            final CourseService svc = (CourseService) registry.lookup(RmiServer.SERVICE_NAME);
            
            List<String> courses = svc.getCourseInventory();
            System.out.println("Received " + courses.size() + " cours(es).");
            
            svc.deleteCourse("WINDOWS_301");
            
            courses = svc.getCourseInventory();
            System.out.println("Received " + courses.size() + " cours(es).");
        } catch (RemoteException e) {
            e.printStackTrace(System.err);
        } catch (NotBoundException e) {
            e.printStackTrace(System.err);
        }
    }
}
