/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.thrift.sizing;

import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TSimpleServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

import com.ociweb.jnb.thrift.ThriftServer;
import com.ociweb.jnb.thrift.gen.CourseService;

public class OutputGrabberServer {

    private static final int PORT = 8000;

    public static void main(String[] args) {
        int retcode = 0;
        try {
            //Use blocking IO because the blocking IO is easier
            // to copy the output.
            final TServerSocket socket = new TServerSocket(PORT);
            final CourseService.Processor processor = new CourseService.Processor(new ThriftServer.Handler());
            final TServer server = new TSimpleServer(processor, socket,
                    new TTransportFactory(), new TCompactProtocol.Factory());
            
            server.serve();
        } catch (TTransportException e) {
            e.printStackTrace(System.err);
            retcode = 1;
        } catch (RuntimeException e) {
            e.printStackTrace(System.err);
            retcode = 1;
        }
        
        System.exit(retcode);
    }
}
