/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.db;

import java.util.Collection;

import com.ociweb.jnb.db.Database;

import junit.framework.TestCase;

public class DatabaseTest extends TestCase {
    
    private Database db;
    
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        db = new Database();
    }

    public void testGetCourseList() {
        Collection<String> courseList = db.getCourseList();
        
        assertNotNull(courseList);
        assertEquals(18, courseList.size());
        
        System.out.println(courseList);
    }

    public void testGetCourse() {
        Course java101 = db.getCourse("JAVA_101");
        assertNotNull(java101);
        assertEquals("Introduction to Java", java101.getName());
    }

    public void testAddCourse() {
        Course course = new Course();
        course.setNumber("FOO_101");
        course.setName("Foo");
        db.addCourse(course);
        
        Course addedCourse = db.getCourse("FOO_101");
        assertNotNull(addedCourse);
        assertEquals("Foo", addedCourse.getName());
    }

    public void testDeleteCourse() {
        db.deleteCourse("JAVA_101");
        Course java101 = db.getCourse("JAVA_101");
        assertNull(java101);
    }

}
