/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.loadrunner;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;

import com.ociweb.jnb.db.Course;
import com.ociweb.jnb.rmi.CourseService;
import com.ociweb.jnb.rmi.RmiServer;

public class RmiLoadRunnerAdapter implements LoadRunner {
    private final CourseService svc;
    
    public RmiLoadRunnerAdapter(final String hostName) {
        try {
            Registry registry = LocateRegistry.getRegistry(hostName, RmiServer.PORT);
            svc = (CourseService) registry.lookup(RmiServer.SERVICE_NAME);
        } catch (final RemoteException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        } catch (NotBoundException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }
    
    @Override
    public List<String> getCourseInventory() {
        final List<String> courses;
        try {
            courses = svc.getCourseInventory();
        } catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        return courses;
    }
    
    @Override
    public Course getCourse(String courseNumber) {
        final Course course;
        try {
            course = svc.getCourse(courseNumber);
        } catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        return course;
    }

    @Override
    public void addCourse(Course classSession) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void deleteCourse(String courseNumber) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void close() {
    }
}
