/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.protobuf;

import java.util.ArrayList;

import com.ociweb.jnb.protobuf.gen.CourseProtos.Course;
import com.ociweb.jnb.protobuf.gen.CourseProtos.Person;
import com.ociweb.jnb.protobuf.gen.CourseProtos.Person.Phone;
import com.ociweb.jnb.protobuf.gen.CourseProtos.Person.PhoneType;

public class ConversionHelper {
    
    public static com.ociweb.jnb.db.Course toDbCourse(Course course) {
        ArrayList<com.ociweb.jnb.db.Person> studentList = new ArrayList<com.ociweb.jnb.db.Person>();
        for (Person dbPerson : course.getStudentList()) {
            studentList.add(toDbPerson(dbPerson));
        }
        
        return new com.ociweb.jnb.db.Course(course.getId(), course.getNumber(), course.getName(), toDbPerson(course.getInstructor()),
                course.getRoomNumber(), studentList);
    }
    
    public static Course fromDbCourse(com.ociweb.jnb.db.Course dbCourse) {
        final Course.Builder builder = Course.newBuilder()
            .setId(dbCourse.getId())
            .setNumber(dbCourse.getNumber())
            .setName(dbCourse.getName())
            .setInstructor(fromDbPerson(dbCourse.getInstructor()))
            .setRoomNumber(dbCourse.getRoomNumber());
        
        for (com.ociweb.jnb.db.Person dbPerson : dbCourse.getStudents()) {
            builder.addStudent(fromDbPerson(dbPerson));
        }
        
        return builder.build();
    }
    
    public static com.ociweb.jnb.db.Person toDbPerson(Person person) {
        ArrayList<com.ociweb.jnb.db.Phone> phoneList = new ArrayList<com.ociweb.jnb.db.Phone>();
        for (Phone phone : person.getPhoneList()) {
            phoneList.add(toDbPhone(phone));
        }
        
        return new com.ociweb.jnb.db.Person(person.getId(), person.getFirstName(), person.getLastName(), person.getEmail(), phoneList);
    }
    
    public static Person fromDbPerson(com.ociweb.jnb.db.Person dbPerson) {
        final Person.Builder builder = Person.newBuilder()
            .setId(dbPerson.getId())
            .setFirstName(dbPerson.getFirstName())
            .setLastName(dbPerson.getLastName())
            .setEmail(dbPerson.getEmail());
        for (com.ociweb.jnb.db.Phone dbPhone : dbPerson.getPhones()) {
            builder.addPhone(fromDbPhone(dbPhone));
        }
        
        return builder.build();
    }
    
    public static com.ociweb.jnb.db.Phone toDbPhone(Phone phone) {
        return new com.ociweb.jnb.db.Phone(phone.getId(), phone.getNumber(), toDbPhoneType(phone.getType()));
    }
    
    public static Phone fromDbPhone(com.ociweb.jnb.db.Phone dbPhone) {
        return Phone.newBuilder()
            .setId(dbPhone.getId())
            .setNumber(dbPhone.getNumber())
            .setType(fromDbPhoneType(dbPhone.getType()))
            .build();
    }
    
    public static com.ociweb.jnb.db.PhoneTypeEnum toDbPhoneType(PhoneType phoneType) {
        com.ociweb.jnb.db.PhoneTypeEnum dbPhoneType = null;
        
        switch(phoneType) {
        case HOME:
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.HOME;
            break;
        case WORK:
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.WORK;
            break;
        case MOBILE:
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.MOBILE;
            break;
        case OTHER:
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.OTHER;
            break;
        default:
            throw new IllegalArgumentException("Unsupported phoneType " + dbPhoneType);
        }
        
        return dbPhoneType;
    }
    
    public static PhoneType fromDbPhoneType(com.ociweb.jnb.db.PhoneTypeEnum dbPhoneType) {
        PhoneType phoneType = null;
        
        switch(dbPhoneType) {
        case HOME:
            phoneType = PhoneType.HOME;
            break;
        case WORK:
            phoneType = PhoneType.WORK;
            break;
        case MOBILE:
            phoneType = PhoneType.MOBILE;
            break;
        case OTHER:
            phoneType = PhoneType.OTHER;
            break;
        default:
            throw new IllegalArgumentException("Unsupported phoneType " + dbPhoneType);
        }
        
        return phoneType;
    }
}
