/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.rmi;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import com.ociweb.jnb.db.Course;
import com.ociweb.jnb.db.Database;

public class RmiSizer {

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Database db = new Database();
        
        Course course = db.getCourse("DATABASE_101");
        
        ObjectOutputStream objOut = new ObjectOutputStream(new FileOutputStream("/tmp/course.ser"));
        
        objOut.writeObject(course);
        objOut.close();
    }
}
