/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.thrift;

import java.util.ArrayList;

import com.ociweb.jnb.thrift.gen.Course;
import com.ociweb.jnb.thrift.gen.Person;
import com.ociweb.jnb.thrift.gen.Phone;

public class ConversionHelper {
    
    public static com.ociweb.jnb.db.Course toDbCourse(Course course) {
        ArrayList<com.ociweb.jnb.db.Person> studentList = new ArrayList<com.ociweb.jnb.db.Person>();
        for (Person dbPerson : course.getStudents()) {
            studentList.add(toDbPerson(dbPerson));
        }
        
        return new com.ociweb.jnb.db.Course(course.getId(), course.getNumber(), course.getName(), toDbPerson(course.getInstructor()),
                course.getRoomNumber(), studentList);
    }
    
    public static Course fromDbCourse(com.ociweb.jnb.db.Course dbCourse) {
        ArrayList<Person> studentList = new ArrayList<Person>();
        for (com.ociweb.jnb.db.Person dbPerson : dbCourse.getStudents()) {
            studentList.add(fromDbPerson(dbPerson));
        }
        
        return new Course(dbCourse.getId(), dbCourse.getNumber(), dbCourse.getName(),
                fromDbPerson(dbCourse.getInstructor()), dbCourse.getRoomNumber(), studentList);
    }
    
    public static com.ociweb.jnb.db.Person toDbPerson(Person person) {
        ArrayList<com.ociweb.jnb.db.Phone> phoneList = new ArrayList<com.ociweb.jnb.db.Phone>();
        for (Phone phone : person.getPhones()) {
            phoneList.add(toDbPhone(phone));
        }
        
        return new com.ociweb.jnb.db.Person(person.getId(), person.getFirstName(), person.getLastName(), person.getEmail(), phoneList);
    }
    
    public static Person fromDbPerson(com.ociweb.jnb.db.Person dbPerson) {
        ArrayList<Phone> phones = new ArrayList<Phone>();
        for (com.ociweb.jnb.db.Phone dbPhone : dbPerson.getPhones()) {
            phones.add(fromDbPhone(dbPhone));
        }
        
        return new Person(dbPerson.getId(), dbPerson.getFirstName(), dbPerson.getLastName(), dbPerson.getEmail(), phones);
    }
    
    public static com.ociweb.jnb.db.Phone toDbPhone(Phone phone) {
        return new com.ociweb.jnb.db.Phone(phone.getId(), phone.getNumber(), toDbPhoneType(phone.getType()));
    }
    
    public static Phone fromDbPhone(com.ociweb.jnb.db.Phone dbPhone) {
        return new Phone(dbPhone.getId(), dbPhone.getNumber(), fromDbPhoneType(dbPhone.getType()));
    }
    
    public static com.ociweb.jnb.db.PhoneTypeEnum toDbPhoneType(String phoneType) {
        com.ociweb.jnb.db.PhoneTypeEnum dbPhoneType = null;
        
        if (com.ociweb.jnb.db.PhoneTypeEnum.HOME.name().equals(phoneType)) {
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.HOME;
        } else if (com.ociweb.jnb.db.PhoneTypeEnum.WORK.name().equals(phoneType)) {
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.WORK;
        } else if (com.ociweb.jnb.db.PhoneTypeEnum.MOBILE.name().equals(phoneType)) {
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.MOBILE;
        } else if (com.ociweb.jnb.db.PhoneTypeEnum.OTHER.name().equals(phoneType)) {
            dbPhoneType = com.ociweb.jnb.db.PhoneTypeEnum.OTHER;
        } else {
            throw new IllegalArgumentException("Unsupported phoneType " + phoneType);
        }
        
        return dbPhoneType;
    }
    
    public static String fromDbPhoneType(com.ociweb.jnb.db.PhoneTypeEnum dbPhoneType) {
        String phoneType = null;
        
        switch(dbPhoneType) {
        case HOME:
            phoneType = com.ociweb.jnb.db.PhoneTypeEnum.HOME.name();
            break;
        case WORK:
            phoneType = com.ociweb.jnb.db.PhoneTypeEnum.WORK.name();
            break;
        case MOBILE:
            phoneType = com.ociweb.jnb.db.PhoneTypeEnum.MOBILE.name();
            break;
        case OTHER:
            phoneType = com.ociweb.jnb.db.PhoneTypeEnum.OTHER.name();
            break;
        default:
            throw new IllegalArgumentException("Unsupported phoneType " + dbPhoneType);
        }
        
        return phoneType;
    }
}
