/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.loadrunner;

import java.util.List;

import javax.ws.rs.core.MediaType;

import com.ociweb.jnb.thrift.ThriftServer;

public class LoadTester {
    
    public static int ITERATIONS = 10000;
    
    public static final void main(final String[] args) {
        if (args.length < 2 && (
                !args[0].equalsIgnoreCase("thrift-compact") || !args[0].equalsIgnoreCase("thrift-binary") ||
                !args[0].equalsIgnoreCase("rest-xml") || !args[0].equalsIgnoreCase("rest-json") ||
                !args[0].equalsIgnoreCase("rmi") || !args[0].equalsIgnoreCase("protobuf"))) {
            System.out.println("You must pass the load type and server name.");
            System.exit(1);
        }
        
        final String type = args[0];
        final String serverName = args[1];
        final LoadRunner runner = getRunner(type, serverName);

        final long startTime = System.currentTimeMillis();
        try {
            for (int i = 0; i < ITERATIONS; i++) {
                if (i % 500 == 0) {
                    System.out.println("Executing run " + i);
                }
                execute(runner);
            }
        } finally {
            runner.close();
        }
        final long stopTime = System.currentTimeMillis();
        
        final long ellapsedTime = stopTime - startTime;
        final String ellapsedTimeStr = Long.toString(ellapsedTime);
        System.out.println("Total run took " + ellapsedTimeStr + " millis");
    }
    
    private static void execute(final LoadRunner runner) {
        final List<String> courseIds = runner.getCourseInventory();
        
        for (final String courseId : courseIds) {
            runner.getCourse(courseId);
        }
    }
    
    private static LoadRunner getRunner(final String type, final String serverName) {
        if (type.equalsIgnoreCase("rmi")) {
            return new RmiLoadRunnerAdapter(serverName);
        } else if (type.equalsIgnoreCase("protobuf")) {
            return new ProtocolBufferLoadRunnerAdapter(serverName);
        } else if (type.equalsIgnoreCase("rest-xml")) {
            return new RestLoadRunnerAdapter(MediaType.APPLICATION_XML, serverName);
        } else if (type.equalsIgnoreCase("rest-json")) {
            return new RestLoadRunnerAdapter(MediaType.APPLICATION_JSON, serverName);
        } else if (type.equalsIgnoreCase("thrift-binary")) {
            return new ThriftLoadRunnerAdapter(ThriftServer.PROTOCOL_FLAG_BINARY, serverName);
        }
        
        return new ThriftLoadRunnerAdapter(ThriftServer.PROTOCOL_FLAG_COMPACT, serverName);
    }
}
