/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

import com.ociweb.jnb.db.Course;

public interface CourseService extends Remote {
    List<String> getCourseInventory() throws RemoteException;
    Course getCourse(String number) throws RemoteException;
    void addCourse(Course course) throws RemoteException;
    void deleteCourse(String number) throws RemoteException;
}