/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.thrift;

import java.util.List;

import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

import com.ociweb.jnb.thrift.gen.CourseNotFoundException;
import com.ociweb.jnb.thrift.gen.CourseService;

/**
 * @author Andrew Prunicki
 */
public class ThriftClient {

    public static final int SOCKET_TIMEOUT = 1000;

    /**
     * @param args
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("You must specify at least the host name.");
            System.exit(1);
        }
        final String hostName = args[0];
        
        boolean compact = true;
        if (args.length > 1) {
            if (ThriftServer.PROTOCOL_FLAG_BINARY.equalsIgnoreCase(args[1])) {
                compact = false;
            }
        }
        
        int retcode = 0;
        final TSocket socket = new TSocket(hostName, ThriftServer.PORT);
        socket.setTimeout(SOCKET_TIMEOUT);
        final TTransport transport = new TFramedTransport(socket);
        final TProtocol protocol;
        if (compact) {
            protocol = new TCompactProtocol(transport);
        } else {
            protocol = new TBinaryProtocol(transport);
        }
        final CourseService.Client client = new CourseService.Client(protocol);
        
        try {
            transport.open();   //The transport must be opened before you can begin using
            
            //All hooked up, start using the service
            List<String> classInv = client.getCourseInventory();
            
            System.out.println("Received " + classInv.size() + " class(es).");
            client.deleteCourse("WINDOWS_301");
            
            classInv = client.getCourseInventory();
            System.out.println("Received " + classInv.size() + " class(es).");
        } catch (TException e) {
            e.printStackTrace(System.err);
            retcode = 1;
        } catch (RuntimeException e) {
            e.printStackTrace(System.err);
            retcode = 1;
        } catch (CourseNotFoundException e) {
            e.printStackTrace();
            retcode = 1;
        } finally {
            transport.close();
        }
        
        System.exit(retcode);
    }
}
