'''
 Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
'''

from thrift.transport import TTransport
from thrift.transport import TSocket
from thrift.transport import THttpClient
from thrift.protocol import TBinaryProtocol
from com.ociweb.jnb.thrift.CourseService import Client

if __name__ == '__main__':
    #Setup the transport and protocol
    socket = TSocket.TSocket("localhost", 8000)
    socket._timeout = 1000
    transport = TTransport.TFramedTransport(socket)
    protocol_factory = TBinaryProtocol.TBinaryProtocolFactory()
    protocol = protocol_factory.getProtocol(transport)
    client = Client(protocol)
    
    try:
        transport.open()     #The transport must be opened before you can begin using
        
        classInv = client.getCourseInventory()
        print "Received", len(classInv), "class(es)"
        
        client.deleteCourse("WINDOWS_301")
        
        classInv = client.getCourseInventory()
        print "Received", len(classInv), "class(es)"
    finally:
        transport.close()
    