/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorOrder(XmlAccessOrder.ALPHABETICAL)
@XmlType(propOrder={"id", "number", "name", "instructor", "roomNumber", "students"})
public class Course implements Serializable {
    private static final long serialVersionUID = 1L;
    
    private int id;
    private String number;
    private String name;
    private Person instructor;
    private String roomNumber;
    private List<Person> students;
    
    public Course() {}
    
    public Course(int id, String number, String name, Person instructor, String roomNumber, List<Person> students) {
        this.id = id;
        this.number = number;
        this.name = name;
        this.instructor = instructor;
        this.roomNumber = roomNumber;
        if (students == null) {
            this.students = new ArrayList<Person>();
        } else {
            this.students= students;
        }
    }
    
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String courseNumber) {
        this.number = courseNumber;
    }

    public String getName() {
        return name;
    }

    public void setName(String courseName) {
        this.name = courseName;
    }

    public Person getInstructor() {
        return instructor;
    }

    public void setInstructor(Person instructor) {
        this.instructor = instructor;
    }

    public String getRoomNumber() {
        return roomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }

    public List<Person> getStudents() {
        return students;
    }
    public void setStudents(List<Person> students) {
        this.students = students;
    }
}
