/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.loadrunner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;

import com.ociweb.jnb.db.Course;
import com.ociweb.jnb.protobuf.ClientHelper;
import com.ociweb.jnb.protobuf.ConversionHelper;
import com.ociweb.jnb.protobuf.ProtoBufServer;

public class ProtocolBufferLoadRunnerAdapter implements LoadRunner {
    private final Socket socket;
    private final ClientHelper clientHelper;
    
    public ProtocolBufferLoadRunnerAdapter(final String hostName) {
        try {
            socket = new Socket(hostName, ProtoBufServer.PORT);
        } catch (final UnknownHostException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        } catch (final IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        try {
            final InputStream is = socket.getInputStream();
            final OutputStream os = socket.getOutputStream();
            clientHelper = new ClientHelper(is, os);
        } catch (final IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getCourseInventory() {
        final List<String> courseList;
        try {
            courseList = clientHelper.getCourseInventory();
        } catch (IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        return courseList;
    }
    
    @Override
    public Course getCourse(String courseNumber) {
        final com.ociweb.jnb.protobuf.gen.CourseProtos.Course course;
        
        try {
            course = clientHelper.getCourse(courseNumber);
        } catch (IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        return ConversionHelper.toDbCourse(course);
    }
    
    @Override
    public void addCourse(Course classSession) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void deleteCourse(String courseNumber) {
        throw new UnsupportedOperationException("Not implemented!");
    }
    
    @Override
    public void close() {
        try {
            socket.close();
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}
