/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.loadrunner;

import java.util.List;

import javax.ws.rs.core.MultivaluedMap;

import com.ociweb.jnb.db.Course;
import com.ociweb.jnb.rest.CourseWrapper;
import com.ociweb.jnb.rest.RestClient;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

public class RestLoadRunnerAdapter implements LoadRunner {
    private final String mimeType;
    private final String hostName;
    private final com.sun.jersey.api.client.Client client;

    public RestLoadRunnerAdapter(final String mimeType, final String hostName) {
        this.mimeType = mimeType;
        this.hostName = hostName;
        client = com.sun.jersey.api.client.Client.create();
    }
    
    @Override
    public List<String> getCourseInventory() {
        WebResource courseInv = client.resource(RestClient.createUrl(hostName, "getCourseInventory"));
        CourseWrapper courseWrapper = courseInv.getRequestBuilder().accept(mimeType).get(CourseWrapper.class);
        return courseWrapper.getCourses();
    }
    
    @Override
    public Course getCourse(String courseNumber) {
        WebResource getCourse = client.resource(RestClient.createUrl(hostName, "getCourse"));
        MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
        queryParams.add("number", courseNumber);
        Course result = getCourse.queryParams(queryParams).getRequestBuilder().accept(mimeType).get(Course.class);
        
        return result;
    }

    @Override
    public void addCourse(Course classSession) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void deleteCourse(String courseNumber) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
    
    @Override
    public void close() {
        client.destroy();
    }
}
