/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.protobuf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import com.google.protobuf.CodedInputStream;
import com.ociweb.jnb.protobuf.gen.CourseProtos;
import com.ociweb.jnb.protobuf.gen.CourseProtos.Course;
import com.ociweb.jnb.protobuf.gen.CourseProtos.CourseList;

public class ClientHelper {
    private final BufferedInputStream bis;
    private final OutputStream bos;
    
    public ClientHelper(InputStream is, OutputStream os) {
        this.bis = new BufferedInputStream(is);
        this.bos = new BufferedOutputStream(os);
    }

    public List<String> getCourseInventory() throws IOException {
        final DataOutputStream dos = new DataOutputStream(bos);
        
        dos.write(ProtoBufServer.START_MESSAGE);
        dos.writeInt(1);
        dos.write(ProtoBufServer.GET_COURSE_INVENTORY);
        dos.flush();
        
        final DataInputStream dis = new DataInputStream(bis);
        final int responseLength = dis.readInt() - 1;
        
        final int type = bis.read();
        if (type != ProtoBufServer.GET_COURSE_INVENTORY) {
            throw new RuntimeException("Unexpected response " + type);
        }
        
        final byte[] msg = new byte[responseLength];
        bis.read(msg);
        
        final CodedInputStream cis = CodedInputStream.newInstance(msg);
        
        final CourseList courseListObj = CourseProtos.CourseList.parseFrom(cis);
        
        return courseListObj.getNumberList();
    }
    
    public Course getCourse(final String courseNum) throws IOException {
        final DataOutputStream dos = new DataOutputStream(bos);
        final byte[] courseNumBytes = courseNum.getBytes();
        
        dos.write(ProtoBufServer.START_MESSAGE);
        dos.writeInt(courseNumBytes.length + 1);
        dos.write(ProtoBufServer.GET_COURSE);
        dos.write(courseNumBytes);
        dos.flush();
        
        final DataInputStream dis = new DataInputStream(bis);
        final int responseLength = dis.readInt() - 1;
        
        final int type = bis.read();
        if (type != ProtoBufServer.GET_COURSE) {
            throw new RuntimeException("Unexpected response " + type);
        }
        
        final byte[] msg = new byte[responseLength];
        bis.read(msg);
        
        final CodedInputStream cis = CodedInputStream.newInstance(msg);
        
        return CourseProtos.Course.parseFrom(cis);
    }

    public void deleteCourse(final String courseNum) throws IOException {
        final DataOutputStream dos = new DataOutputStream(bos);
        final byte[] courseNumBytes = courseNum.getBytes();
        
        dos.write(ProtoBufServer.START_MESSAGE);
        dos.writeInt(courseNumBytes.length + 1);
        dos.write(ProtoBufServer.DEL_COURSE);
        dos.write(courseNumBytes);
        dos.flush();
    }
}
