/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;

public class ProtoBufClient {
    
    public static void main(final String[] args) {
        final Socket socket;
        try {
            socket = new Socket("localhost", ProtoBufServer.PORT);
        } catch (final UnknownHostException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        } catch (final IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        
        try {
            final InputStream is = socket.getInputStream();
            final OutputStream os = socket.getOutputStream();
            final ClientHelper clientHelper = new ClientHelper(is, os);
            
            List<String> courseList = clientHelper.getCourseInventory();
            System.out.println("Received " + courseList.size() + " cours(es).");
            
            clientHelper.deleteCourse("WINDOWS_301");
            
            courseList = clientHelper.getCourseInventory();
            System.out.println("Received " + courseList.size() + " cours(es).");
        } catch (final IOException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        } finally {
            try {
                socket.close();
            } catch (final IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}
