/*
 * Copyright 2009 Andrew Prunicki <prunand@iit.edu,prunicki@ociweb.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ociweb.jnb.rest;

import java.util.List;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

public class RestClient {
    
    private static final String LOCALHOST = "localhost";
    private static final int PORT = 8080;

    /**
     * @param args
     */
    public static void main(String[] args) {
        Client client = Client.create();
        
        WebResource courseInv = client.resource(createUrl(LOCALHOST, "getCourseInventory"));
        CourseWrapper courseWrapper = courseInv.getRequestBuilder().accept(MediaType.APPLICATION_XML).get(CourseWrapper.class);
        List<String> courses = courseWrapper.getCourses();
        System.out.println("Received " + courses.size() + " cours(es).");
        
        WebResource deleteCourse = client.resource(createUrl(LOCALHOST, "deleteCourse"));
        MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
        queryParams.add("number", "WINDOWS_301");
        deleteCourse.queryParams(queryParams).get(String.class);
        
        courseWrapper = courseInv.get(CourseWrapper.class);
        courses = courseWrapper.getCourses();
        System.out.println("Received " + courses.size() + " cours(es).");
        
        client.destroy();
    }
    
    public static String createUrl(String hostName, String serviceName) {
        return "http://" + hostName + ":" + PORT + "/" + serviceName;
    }
}
