package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.StringEscapeUtils;


public class StringEscapeExample {
    private static final String[] testStrings = {
            "Simple", "I told him, \"She said, \'Hey, are you there?\'\"",
            "static class Foo<T extends List & Serializable>"
        };

    public static void main(String[] args) {
        System.out.println(StringEscapeUtils.escapeHtml("Intel Pentium 4 @ 2.40 GHz"));

        // escapeCsv adds quotes, if needed
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeCsv(testString);
            final String unescaped = StringEscapeUtils.unescapeCsv(escaped);

            System.out.println("StringEscapeUtils.escapeCsv(\"" + testString +
                "\") = \n\t" + escaped);
            System.out.println("unescaped = " + unescaped);
        }

        System.out.println();

        // escapeHtml escapes html special characters
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeHtml(testString);
            final String unescaped = StringEscapeUtils.unescapeHtml(escaped);

            System.out.println("StringEscapeUtils.escapeHtml(\"" + testString +
                "\") = \n\t" + escaped);
            System.out.println("unescaped = " + unescaped);
        }

        System.out.println();

        // escapeJava escapes Java special characters
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeJava(testString);
            final String unescaped = StringEscapeUtils.unescapeJava(escaped);

            System.out.println("StringEscapeUtils.escapeJava(\"" + testString +
                "\") = \n\t" + escaped);
            System.out.println("unescaped = " + unescaped);
        }

        System.out.println();

        // escapeJavaScript escapes JavaScript special characters
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeJavaScript(
                    testString);
            final String unescaped = StringEscapeUtils.unescapeJavaScript(
                    escaped);

            System.out.println("StringEscapeUtils.escapeJavaScript(\"" +
                testString + "\") = \n\t" + escaped);
            System.out.println("unescaped = " + unescaped);
        }

        System.out.println();

        // escapeSql escapes Sql special characters
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeSql(testString);

            System.out.println("StringEscapeUtils.escapeSql(\"" + testString +
                "\") = \n\t" + escaped);
        }

        System.out.println();

        // escapeXml escapes Xml special characters (similar to html, but also
        // escapes &apos;
        for (String testString : testStrings) {
            final String escaped = StringEscapeUtils.escapeXml(testString);
            final String unescaped = StringEscapeUtils.unescapeXml(escaped);

            System.out.println("StringEscapeUtils.escapeXml(\"" + testString +
                "\") = \n\t" + escaped);
            System.out.println("unescaped = " + unescaped);
        }

        System.out.println("--------------------");
        System.out.println(StringEscapeUtils.escapeHtml("StringEscapeUtils.escapeCsv(\"Simple\") = \n" +
                "\tSimple\n" +
                "unescaped = Simple\n" +
                "StringEscapeUtils.escapeCsv(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\t\"I told him, \"\"She said, 'Hey, are you there?'\"\"\"\n" +
                "unescaped = I told him, \"She said, 'Hey, are you there?'\"\n" +
                "StringEscapeUtils.escapeCsv(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo<T extends List & Serializable>\n" +
                "unescaped = static class Foo<T extends List & Serializable>\n" +
                "\n" +
                "StringEscapeUtils.escapeHtml(\"Simple\") = \n" +
                "\tSimple\n" +
                "unescaped = Simple\n" +
                "StringEscapeUtils.escapeHtml(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\tI told him, &quot;She said, 'Hey, are you there?'&quot;\n" +
                "unescaped = I told him, \"She said, 'Hey, are you there?'\"\n" +
                "StringEscapeUtils.escapeHtml(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo&lt;T extends List &amp; Serializable&gt;\n" +
                "unescaped = static class Foo<T extends List & Serializable>\n" +
                "\n" +
                "StringEscapeUtils.escapeJava(\"Simple\") = \n" +
                "\tSimple\n" +
                "unescaped = Simple\n" +
                "StringEscapeUtils.escapeJava(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\tI told him, \\\"She said, 'Hey, are you there?'\\\"\n" +
                "unescaped = I told him, \"She said, 'Hey, are you there?'\"\n" +
                "StringEscapeUtils.escapeJava(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo<T extends List & Serializable>\n" +
                "unescaped = static class Foo<T extends List & Serializable>\n" +
                "\n" +
                "StringEscapeUtils.escapeJava(\"Simple\") = \n" +
                "\tSimple\n" +
                "unescaped = Simple\n" +
                "StringEscapeUtils.escapeJava(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\tI told him, \\\"She said, \\'Hey, are you there?\\'\\\"\n" +
                "unescaped = I told him, \"She said, 'Hey, are you there?'\"\n" +
                "StringEscapeUtils.escapeJava(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo<T extends List & Serializable>\n" +
                "unescaped = static class Foo<T extends List & Serializable>\n" +
                "\n" +
                "StringEscapeUtils.escapeSql(\"Simple\") = \n" +
                "\tSimple\n" +
                "StringEscapeUtils.escapeSql(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\tI told him, \"She said, ''Hey, are you there?''\"\n" +
                "StringEscapeUtils.escapeSql(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo<T extends List & Serializable>\n" +
                "\n" +
                "StringEscapeUtils.escapeXml(\"Simple\") = \n" +
                "\tSimple\n" +
                "unescaped = Simple\n" +
                "StringEscapeUtils.escapeXml(\"I told him, \"She said, 'Hey, are you there?'\"\") = \n" +
                "\tI told him, &quot;She said, &apos;Hey, are you there?&apos;&quot;\n" +
                "unescaped = I told him, \"She said, 'Hey, are you there?'\"\n" +
                "StringEscapeUtils.escapeXml(\"static class Foo<T extends List & Serializable>\") = \n" +
                "\tstatic class Foo&lt;T extends List &amp; Serializable&gt;\n" +
                "unescaped = static class Foo<T extends List & Serializable>"));
    }

}
