package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.ArrayUtils;

import java.util.Arrays;


public class ArrayExample {
    public static void main(String[] args) {

        // add an element to the end of an array
        System.out.println("ArrayUtils.add(new int[4], 6) = " +
            Arrays.toString(ArrayUtils.add(new int[4], 6)));

        // insert an element into an array
        System.out.println("ArrayUtils.add(new int[4], 2, 6) = " +
            Arrays.toString(ArrayUtils.add(new int[4], 2, 6)));

        // merge two arrays
        System.out.println(
            "ArrayUtils.addAll(new int[] {1, 2}, new int [] {5, 6}) = " +
            Arrays.toString(
                ArrayUtils.addAll(new int[] { 1, 2 }, new int[] { 5, 6 })));

        // shallow clone of an array
        System.out.println("ArrayUtils.clone(new int[][] {{ 1, 2 }}) = " +
            Arrays.toString(ArrayUtils.clone(new int[][] {
                        { 1, 2 }
                    })));

        // check if the value is in the array
        System.out.println("ArrayUtils.contains(new int[] { 1, 2 }, 2) = " +
            ArrayUtils.contains(new int[] { 1, 2 }, 2));

        // remove an element from an array by index
        System.out.println("ArrayUtils.remove(new int[] {1, 2, 3}, 1) = " +
            Arrays.toString(ArrayUtils.remove(new int[] { 1, 2, 3 }, 1)));

        // remove an element from an array
        System.out.println(
            "ArrayUtils.removeElement(new int[] {1, 2, 3}, 1) = " +
            Arrays.toString(
                ArrayUtils.removeElement(new int[] { 1, 2, 3 }, 1)));

        // reverse an array (in place)
        final int[] array = { 1, 2, 3 };
        ArrayUtils.reverse(array);
        System.out.println("reversed array = " + Arrays.toString(array));

        // extract a subarray (first is inclusive, last is exclusive)
        System.out.println(
            "ArrayUtils.subarray(new int[] {1, 2, 3, 4}, 1, 3)) = " +
            Arrays.toString(
                ArrayUtils.subarray(new int[] { 1, 2, 3, 4 }, 1, 3)));

        // convert an array of two-element arrays to a map
        System.out.println(
            "ArrayUtils.toMap(new Object[][]{{\"DE\", 1}, {\"PA\", 2 }, " +
                    "{\"NJ\", 3}}) = \n\t" +
            ArrayUtils.toMap(
                new Object[][] {
                    { "DE", 1 },
                    { "PA", 2 },
                    { "NJ", 3 }
                }));

        // convert primitives to wrappers
        System.out.println(
            "ArrayUtils.toObject(new int[] { 1, 2, 3, 4 }) = " +
            Arrays.toString(
                ArrayUtils.toObject(new int[] { 1, 2, 3, 4 })));
        // convert wrappers to primitives
        System.out.println(
            "ArrayUtils.toPrimitive(new Integer[] { 1, 2, 3, 4 }) = " +
            Arrays.toString(
                ArrayUtils.toPrimitive(new Integer[] { 1, 2, 3, 4 })));

    }
}
