package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;


public class StringUtilsExample {
    public static void main(String[] args) {

        // cuts the String down to never be longer than 7, using an ellipsis
        System.out.println(
            "StringUtils.abbreviate(\"This text is just too long.\", 7) = " +
            StringUtils.abbreviate("This text is just too long.", 7));

        // capitalizes, uncapitalizes, lowercases, or uppercases the word
        System.out.println("StringUtils.capitalize(\"faMily\") = " +
            StringUtils.capitalize("faMily"));
        System.out.println("StringUtils.uncapitalize(\"FaMily\") = " +
            StringUtils.uncapitalize("FaMily"));
        System.out.println("StringUtils.lowerCase(\"faMily\") = " +
            StringUtils.lowerCase("faMily"));
        System.out.println("StringUtils.upperCase(\"faMily\") = " +
            StringUtils.upperCase("faMily"));

        // centers the word, padding with spaces
        System.out.println("StringUtils.center(\"Title\", 15) = '" +
            StringUtils.center("Title", 15) + "'");

        // removes the given separator from the end of the String, if necessary
        System.out.println(
            "StringUtils.chomp(\"I like apple pie!\", \"!\") = " +
            StringUtils.chomp("I like apple pie!", "!"));

        // removes the last character from the String
        System.out.println("StringUtils.chop(\"I like apple pie!\") = " +
            StringUtils.chop("I like apple pie!"));

        // similar to String.contains(), but is nullsafe
        // there are many similar methods (containsAny, containsIgnoreCase, etc)
        System.out.println(
            "StringUtils.contains(\"I like apple pie!\", \"apple\") = " +
            StringUtils.contains("I like apple pie!", "apple"));

        // returns either the first String or the second String (if the first
        // is null or empty)
        System.out.println("StringUtils.defaultIfEmpty(null, \"oops!\") = " +
            StringUtils.defaultIfEmpty(null, "oops!"));

        // removes all whitespace from the String
        System.out.println(
            "StringUtils.deleteWhitespace(\"I like apple pie!\") = " +
            StringUtils.deleteWhitespace("I like apple pie!"));

        // returns the part of the second String after a difference is seen
        System.out.println("StringUtils.difference(\"I like apple pie!\", " +
            "\"I like cherry pie!\") = " +
            StringUtils.difference("I like apple pie!", "I like cherry pie!"));

        // nullsafe check on the end or beginning of a String
        System.out.println(
            "StringUtils.endsWith(\"I like apple pie!\", \"cake!\") = " +
            StringUtils.endsWith("I like apple pie!", "cake!"));
        System.out.println(
            "StringUtils.startsWith(\"I like apple pie!\", \"I \") = " +
            StringUtils.startsWith("I like apple pie!", "I "));

        // nullsafe equality check
        System.out.println(
            "StringUtils.equals(null, \"I like apple pie!\") = " +
            StringUtils.equals(null, "I like apple pie!"));

        // returns the commons prefix of an array of Strings
        System.out.println(
            "StringUtils.getCommonPrefix(new String[] {\"bar\", \"baz\"}) = " +
            StringUtils.getCommonPrefix(new String[] { "bar", "baz" }));

        // returns the number of character changes needed to turn one String
        // into another
        System.out.println(
            "StringUtils.getLevenshteinDistance(\"I like pie!\", " +
            "\"I like cake!\") = " +
            StringUtils.getLevenshteinDistance("I like pie!", "I like cake!"));

        // similar to String.indexOf(), but is nullsafe
        // there are many similar methods (indexOfAny, indexOfDifference, etc.)
        // there are also versions of lastIndexOf
        System.out.println(
            "StringUtils.indexOf(\"I like apple pie!\", \"apple\") = " +
            StringUtils.indexOf("I like apple pie!", "apple"));

        // returns whether the String contains only unicode letters
        // there are similar methods for numeric, alphanumeric,
        // including space, etc.
        System.out.println("StringUtils.isAlpha(\"I like apple pie!\") = " +
            StringUtils.isAlpha("I like apple pie!"));

        // nullsafe checks for empty and blank Strings
        System.out.println("StringUtils.isBlank(\"I like apple pie!\") = " +
            StringUtils.isBlank("I like apple pie!"));
        System.out.println("StringUtils.isBlank(\" \") = " +
            StringUtils.isBlank(" "));
        System.out.println("StringUtils.isBlank(\"\") = " +
            StringUtils.isBlank(""));
        System.out.println("StringUtils.isBlank(null) = " +
            StringUtils.isBlank(null));
        System.out.println("StringUtils.isEmpty(\"I like apple pie!\") = " +
            StringUtils.isEmpty("I like apple pie!"));
        System.out.println("StringUtils.isEmpty(\" \") = " +
            StringUtils.isEmpty(" "));
        System.out.println("StringUtils.isEmpty(\"\") = " +
            StringUtils.isEmpty(""));
        System.out.println("StringUtils.isEmpty(null) = " +
            StringUtils.isEmpty(null));

        // joins the elements of the array to a single String with the given
        // separator
        System.out.println(
            "StringUtils.join(new Object[] {5, \"happy\", 3.14}, '-') = " +
            StringUtils.join(new Object[] { 5, "happy", 3.14 }, '-'));

        // like String.substring, but is ok with the String being too small,
        // and can pad the difference
        System.out.println(
            "StringUtils.left(\"I like apple pie!\", 10) + \"'\" = '" +
            StringUtils.left("I like apple pie!", 10) + "'");
        System.out.println(
            "StringUtils.left(\"I like apple pie!\", 20) + \"'\" = '" +
            StringUtils.left("I like apple pie!", 20) + "'");
        System.out.println(
            "StringUtils.leftPad(\"I like apple pie!\", 20) + \"'\" = '" +
            StringUtils.leftPad("I like apple pie!", 20) + "'");
        System.out.println(
            "StringUtils.right(\"I like apple pie!\", 10) + \"'\" = '" +
            StringUtils.right("I like apple pie!", 10) + "'");
        System.out.println(
            "StringUtils.right(\"I like apple pie!\", 20) + \"'\" = '" +
            StringUtils.right("I like apple pie!", 20) + "'");
        System.out.println(
            "StringUtils.rightPad(\"I like apple pie!\", 20) + \"'\" = '" +
            StringUtils.rightPad("I like apple pie!", 20) + "'");

        // nullsafe version of String.length()
        System.out.println("StringUtils.length(null) = " +
            StringUtils.length(null));

        // similar to String.replace(), but nullsafe
        // there are many variants of replaceXXX methods
        System.out.println(
            "StringUtils.remove(\"I like apple pie!\", \"e\") = " +
            StringUtils.remove("I like apple pie!", "e"));
        System.out.println(
            "StringUtils.replace(\"I like apple pie!\", \"e\", \"u\") = " +
            StringUtils.replace("I like apple pie!", "e", "u"));

        // creates a new String from a repetition of another String
        System.out.println("StringUtils.repeat(\"apple \", 5) = " +
            StringUtils.repeat("apple ", 5));

        // similar to StringBuffer.reverse(), but nullsafe
        System.out.println("StringUtils.reverse(\"I like apple pie!\") = " +
            StringUtils.reverse("I like apple pie!"));

        // splits a String into an array using whitespace as the delimiter.
        // There are many variant methods
        System.out.println("StringUtils.split(\"I like apple pie!\") = " +
            Arrays.toString(StringUtils.split("I like apple pie!")));

        // nullsafe removal of all leading and trailing whitespace.  There are
        // many variant methods
        System.out.println(
            "StringUtils.strip(\"\\t I like apple pie!\\r\\n\") = '" +
            StringUtils.strip("\t I like apple pie!\r\n") + "'");

        // similar to String.substring(), but nullsafe.  There are many variant
        // methods
        System.out.println(
            "StringUtils.substring(\"I like apple pie!\", 4) = " +
            StringUtils.substring("I like apple pie!", 4));
        System.out.println("StringUtils.substring(null, 4) = " +
            StringUtils.substring(null, 4));

        // converts lowercase to caps and vice versa
        System.out.println("StringUtils.swapCase(\"I like apple pie!\") = " +
            StringUtils.swapCase("I like apple pie!"));

        // nullsafe version of String.trim().  Leaves non-space whitespace
        System.out.println("StringUtils.trim(\"  /tI like apple pie!  \") = '" +
            StringUtils.trim("  /tI like apple pie!  ") + "'");
    }
}
