package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.WordUtils;


public class WordExample {
    public static void main(String[] args) {
        // abbreviate somewhere between 2 and 8 characters
        System.out.println(
            "WordUtils.abbreviate(\"Object Computing, Inc.\", 2, 8, \"huh?\") = " +
            WordUtils.abbreviate("Object Computing, Inc.", 2, 8, "..."));

        // capitalize all words
        System.out.println(
            "WordUtils.capitalize(\"object computing, inc.\") = " +
            WordUtils.capitalize("object COMPUTING, inc."));

        // capitalize all words, removing extra capitalizations
        System.out.println(
            "WordUtils.capitalizeFully(\"object computing, inc.\") = " +
            WordUtils.capitalizeFully("object COMPUTING, inc."));

        // create an initial
        System.out.println("WordUtils.initials(\"object computing, inc.\") = " +
            WordUtils.initials("object COMPUTING, inc."));

        // swap case for all letters
        System.out.println("WordUtils.swapCase(\"object computing, inc.\") = " +
            WordUtils.swapCase("object COMPUTING, inc."));

        // uncapitalize all words
        System.out.println(
            "WordUtils.uncapitalize(\"object computing, inc.\") = " +
            WordUtils.uncapitalize("object COMPUTING, inc."));

        // wrap a phrase after 12 characters
        System.out.println(
            "WordUtils.wrap(\"This is a sentence to show the wrapping\", 12) = " +
            WordUtils.wrap("This is a sentence to show the wrapping", 12));
    }
}
