package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.ClassUtils;

import java.util.ArrayList;
import java.util.Arrays;


public class ClassExample {
    public static void main(String[] args) {

        // class and package names
        System.out.println(
            "ClassUtils.getPackageCanonicalName(ClassExample.class) = " +
            ClassUtils.getPackageCanonicalName(ClassExample.class));
        System.out.println("ClassUtils.getPackageName(ClassExample.class) = " +
            ClassUtils.getPackageName(ClassExample.class));
        System.out.println(
            "ClassUtils.getShortCanonicalName(ClassExample.class) = " +
            ClassUtils.getShortCanonicalName(ClassExample.class));
        System.out.println(
            "ClassUtils.getShortClassName(ClassExample.class) = " +
            ClassUtils.getShortClassName(ClassExample.class));

        // primitive and wrapper conversion
        System.out.println("ClassUtils.primitiveToWrapper(Byte.TYPE) = " +
            ClassUtils.primitiveToWrapper(Byte.TYPE));
        System.out.println("ClassUtils.primitivesToWrappers(new Class[] " +
            "{Byte.TYPE, Integer.TYPE}) = \n\t" +
            Arrays.toString(
                ClassUtils.primitivesToWrappers(
                    new Class[] { Byte.TYPE, Integer.TYPE })));
        System.out.println("ClassUtils.wrapperToPrimitive(Byte.class) = " +
            ClassUtils.wrapperToPrimitive(Byte.class));
        System.out.println(
            "ClassUtils.primitivesToWrappers(new Class[] {Byte.class, " +
            "Integer.class}) = \n\t" +
            Arrays.toString(
                ClassUtils.wrappersToPrimitives(
                    new Class[] { Byte.class, Integer.class })));

        // determining the classes for lots of objects
        System.out.println("ClassUtils.toClass(new Object[] {5, \"happy\", " +
            "new ArrayList()}) = \n\t" +
            Arrays.toString(
                ClassUtils.toClass(
                    new Object[] { 5, "happy", new ArrayList() })));

        // determining class names for lots of classes
        System.out.println(
            "ClassUtils.convertClassesToClassNames(Integer.TYPE, " +
            "String.class, ArrayList.class) = \n\t" +
            ClassUtils.convertClassesToClassNames(
                Arrays.asList(Integer.TYPE, String.class, ArrayList.class)));
    }
}
