package com.ociweb.jnb.jul2009;

import org.apache.commons.lang.BooleanUtils;


public class BooleanExample {
    public static void main(String[] args) {

        // convert int to boolean and vice verse (assumes 0 is false -
        // overriden version allow that to be different
        System.out.println("BooleanUtils.toBoolean(0) = " +
            BooleanUtils.toBoolean(0));
        System.out.println("BooleanUtils.toInteger(true) = " +
            BooleanUtils.toInteger(true));

        // using alternate String tuples for true|false
        System.out.println("BooleanUtils.toStringOnOff(true) = " +
            BooleanUtils.toStringOnOff(true));
        System.out.println("BooleanUtils.toStringOnOff(true) = " +
            BooleanUtils.toStringYesNo(true));

        // defining a custom String tuple for true|false
        System.out.println(
            "BooleanUtils.toString(true, \"Yep!\", \"Nope!\") = " +
            BooleanUtils.toString(true, "Yep!", "Nope!"));
        System.out.println(
            "BooleanUtils.toString(false, \"Yep!\", \"Nope!\") = " +
            BooleanUtils.toString(false, "Yep!", "Nope!"));

        // xor calculation on an array of booleans
        System.out.println(
            "BooleanUtils.xor(new boolean[] {true, false, true, true}) = " +
            BooleanUtils.xor(new boolean[] { true, false, true, true }));
        System.out.println(
            "BooleanUtils.xor(new boolean[] {true, true, true, true}) = " +
            BooleanUtils.xor(new boolean[] { true, true, true, true }));
        System.out.println(
            "BooleanUtils.xor(new boolean[] {false, false, false, false}) = " +
            BooleanUtils.xor(new boolean[] { false, false, false, false }));
    }
}
