package com.ociweb.jnb.oct2009;

import java.util.Arrays;


public class BuilderExample1 implements Comparable<BuilderExample1> {
    private int id;
    private String[] names;

    @Override
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }

        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }

        BuilderExample1 rhs = (BuilderExample1) o;

        if (id != rhs.id) {
            return false;
        }

        if (!Arrays.equals(names, rhs.names)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = id;
        result = (31 * result) + ((names != null) ? Arrays.hashCode(names) : 0);

        return result;
    }

    public int compareTo(BuilderExample1 o) {

        if (id < o.id) {
            return -1;
        } else if (id < o.id) {
            return 1;
        } else {

            if (names.length != o.names.length) {
                return (names.length < o.names.length) ? -1 : +1;
            } else {

                for (int i = 0; i < names.length; i++) {
                    String name = names[i];
                    String otherName = o.names[i];
                    final int nameCompare = name.compareTo(otherName);

                    if (nameCompare != 0) {
                        return nameCompare;
                    }
                }
            }

            return 0;
        }
    }
}
