package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;


public class BuilderExample3 implements Comparable<BuilderExample3> {
    private int id;
    private String[] names;

    @Override
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }

        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }

        BuilderExample3 rhs = (BuilderExample3) o;

        return new EqualsBuilder().append(id, rhs.id).append(names, rhs.names)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(id).append(names).toHashCode();
    }

    public int compareTo(BuilderExample3 o) {
        return new CompareToBuilder().append(id, o.id).append(names, o.names)
                .toComparison();
    }
}
